/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.vm.block;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.UUID;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.vm.VMDevice;
import li.cil.oc2.api.bus.device.vm.VMDeviceLoadResult;
import li.cil.oc2.api.bus.device.vm.context.VMContext;
import li.cil.oc2.common.bus.device.util.IdentityProxy;
import li.cil.oc2.common.bus.device.util.OptionalAddress;
import li.cil.oc2.common.serialization.BlobStorage;
import li.cil.oc2.common.vm.device.SimpleFramebufferDevice;
import li.cil.oc2.jcodec.common.model.Picture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class MonitorDevice
extends IdentityProxy<BlockEntity>
implements VMDevice {
    private static final String ADDRESS_TAG_NAME = "address";
    private static final String BLOB_HANDLE_TAG_NAME = "blob";
    public static final int WIDTH = 640;
    public static final int HEIGHT = 480;
    private final BooleanConsumer onMountedChanged;
    @Nullable
    private SimpleFramebufferDevice device;
    private final OptionalAddress address = new OptionalAddress();
    @Nullable
    private UUID blobHandle;

    public MonitorDevice(BlockEntity identity, BooleanConsumer onMountedChanged) {
        super(identity);
        this.onMountedChanged = onMountedChanged;
    }

    public boolean hasChanges() {
        SimpleFramebufferDevice framebufferDevice = this.device;
        return framebufferDevice != null && framebufferDevice.hasChanges();
    }

    public boolean applyChanges(Picture picture) {
        SimpleFramebufferDevice framebufferDevice = this.device;
        return framebufferDevice != null && framebufferDevice.applyChanges(picture);
    }

    @Override
    public VMDeviceLoadResult mount(VMContext context) {
        if (!this.allocateDevice(context)) {
            return VMDeviceLoadResult.fail();
        }
        assert (this.device != null);
        if (!this.address.claim(context, this.device)) {
            return VMDeviceLoadResult.fail();
        }
        this.onMountedChanged.accept(true);
        return VMDeviceLoadResult.success();
    }

    @Override
    public void unmount() {
        SimpleFramebufferDevice framebufferDevice = this.device;
        this.device = null;
        if (framebufferDevice != null) {
            framebufferDevice.close();
        }
        if (this.blobHandle != null) {
            BlobStorage.close(this.blobHandle);
        }
        this.onMountedChanged.accept(false);
    }

    @Override
    public void dispose() {
        if (this.blobHandle != null) {
            BlobStorage.delete(this.blobHandle);
            this.blobHandle = null;
        }
        this.address.clear();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.blobHandle != null) {
            tag.m_128362_(BLOB_HANDLE_TAG_NAME, this.blobHandle);
        }
        if (this.address.isPresent()) {
            tag.m_128356_(ADDRESS_TAG_NAME, this.address.getAsLong());
        }
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128403_(BLOB_HANDLE_TAG_NAME)) {
            this.blobHandle = tag.m_128342_(BLOB_HANDLE_TAG_NAME);
        }
        if (tag.m_128425_(ADDRESS_TAG_NAME, 4)) {
            this.address.set(tag.m_128454_(ADDRESS_TAG_NAME));
        }
    }

    private boolean allocateDevice(VMContext context) {
        if (!context.getMemoryAllocator().claimMemory(4096)) {
            return false;
        }
        try {
            this.device = this.createFrameBufferDevice();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private SimpleFramebufferDevice createFrameBufferDevice() throws IOException {
        this.blobHandle = BlobStorage.validateHandle(this.blobHandle);
        FileChannel channel = BlobStorage.getOrOpen(this.blobHandle);
        MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, 614400L);
        return new SimpleFramebufferDevice(640, 480, buffer);
    }
}

