/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.vm.item;

import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.ItemDevice;
import li.cil.oc2.api.bus.device.vm.VMDevice;
import li.cil.oc2.api.bus.device.vm.VMDeviceLoadResult;
import li.cil.oc2.api.bus.device.vm.context.VMContext;
import li.cil.oc2.api.bus.device.vm.event.VMResumedRunningEvent;
import li.cil.oc2.common.bus.device.util.IdentityProxy;
import li.cil.oc2.common.bus.device.util.OptionalAddress;
import li.cil.oc2.common.bus.device.util.OptionalInterrupt;
import li.cil.oc2.common.config.AsyncConfig;
import li.cil.oc2.common.serialization.BlobStorage;
import li.cil.oc2.common.serialization.NBTSerialization;
import li.cil.oc2.common.util.Event;
import li.cil.sedna.api.device.BlockDevice;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.device.virtio.VirtIOBlockDevice;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractBlockStorageDevice<TBlock extends BlockDevice, TIdentity>
extends IdentityProxy<TIdentity>
implements VMDevice,
ItemDevice {
    protected static final Logger LOGGER = LogManager.getLogger();
    private static final String DEVICE_TAG_NAME = "device";
    private static final String ADDRESS_TAG_NAME = "address";
    private static final String INTERRUPT_TAG_NAME = "interrupt";
    private static final String BLOB_HANDLE_TAG_NAME = "blob";
    protected static final ExecutorService WORKERS = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r, "Block Device Initializer");
        thread.setDaemon(false);
        return thread;
    });
    protected final boolean readonly;
    protected VirtIOBlockDevice device;
    private CompletableFuture<Void> openJob;
    private final OptionalAddress address = new OptionalAddress();
    private final OptionalInterrupt interrupt = new OptionalInterrupt();
    private CompoundTag deviceTag;
    @Nullable
    protected UUID blobHandle;

    protected AbstractBlockStorageDevice(TIdentity identity, boolean readonly) {
        super(identity);
        this.readonly = readonly;
    }

    @Override
    public VMDeviceLoadResult mount(VMContext context) {
        if (!this.allocateDevice(context)) {
            return VMDeviceLoadResult.fail();
        }
        if (!this.address.claim(context, (MemoryMappedDevice)this.device)) {
            return VMDeviceLoadResult.fail();
        }
        if (!this.interrupt.claim(context)) {
            return VMDeviceLoadResult.fail();
        }
        this.device.getInterrupt().set(this.interrupt.getAsInt(), context.getInterruptController());
        context.getEventBus().register(this);
        if (this.deviceTag != null) {
            NBTSerialization.deserialize(this.deviceTag, this.device);
        }
        return VMDeviceLoadResult.success();
    }

    @Override
    public void unmount() {
        this.closeDevice();
        if (this.blobHandle != null) {
            if (((Boolean)AsyncConfig.SERVER.asyncStorageOperations.get()).booleanValue()) {
                BlobStorage.closeAsync(this.blobHandle).exceptionally(e -> {
                    LOGGER.error("Error closing blob asynchronously: " + String.valueOf(this.blobHandle), e);
                    return null;
                });
            } else {
                BlobStorage.close(this.blobHandle);
            }
        }
    }

    @Override
    public void dispose() {
        this.deviceTag = null;
        this.address.clear();
        this.interrupt.clear();
    }

    @Override
    public void exportToItemStack(CompoundTag nbt) {
        if (this.blobHandle != null) {
            nbt.m_128362_(BLOB_HANDLE_TAG_NAME, this.blobHandle);
        }
    }

    @Override
    public void importFromItemStack(CompoundTag nbt) {
        if (nbt.m_128403_(BLOB_HANDLE_TAG_NAME)) {
            this.blobHandle = nbt.m_128342_(BLOB_HANDLE_TAG_NAME);
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.blobHandle != null) {
            tag.m_128362_(BLOB_HANDLE_TAG_NAME, this.blobHandle);
        }
        if (this.device != null) {
            this.deviceTag = NBTSerialization.serialize(this.device);
        }
        if (this.deviceTag != null) {
            tag.m_128365_(DEVICE_TAG_NAME, (Tag)this.deviceTag);
        }
        if (this.address.isPresent()) {
            tag.m_128356_(ADDRESS_TAG_NAME, this.address.getAsLong());
        }
        if (this.interrupt.isPresent()) {
            tag.m_128405_(INTERRUPT_TAG_NAME, this.interrupt.getAsInt());
        }
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128403_(BLOB_HANDLE_TAG_NAME)) {
            this.blobHandle = tag.m_128342_(BLOB_HANDLE_TAG_NAME);
        }
        if (tag.m_128425_(DEVICE_TAG_NAME, 10)) {
            this.deviceTag = tag.m_128469_(DEVICE_TAG_NAME);
        }
        if (tag.m_128425_(ADDRESS_TAG_NAME, 4)) {
            this.address.set(tag.m_128454_(ADDRESS_TAG_NAME));
        }
        if (tag.m_128425_(INTERRUPT_TAG_NAME, 3)) {
            this.interrupt.set(tag.m_128451_(INTERRUPT_TAG_NAME));
        }
    }

    public static void unmount(CompoundTag tag) {
        if (tag.m_128403_(BLOB_HANDLE_TAG_NAME)) {
            UUID blobHandle = tag.m_128342_(BLOB_HANDLE_TAG_NAME);
            if (((Boolean)AsyncConfig.SERVER.asyncStorageOperations.get()).booleanValue()) {
                BlobStorage.closeAsync(blobHandle).exceptionally(e -> {
                    LOGGER.error("Error closing blob asynchronously during unmount: " + String.valueOf(blobHandle), e);
                    return null;
                });
            } else {
                BlobStorage.close(blobHandle);
            }
        }
    }

    @Subscribe
    public void handleResumedRunningEvent(VMResumedRunningEvent event) {
        this.joinOpenJob();
    }

    protected void setOpenJob(CompletableFuture<Void> job) {
        this.joinOpenJob();
        this.openJob = job;
    }

    protected void joinOpenJob() {
        if (this.openJob != null) {
            try {
                this.openJob.join();
            }
            catch (CompletionException e) {
                LOGGER.error((Object)e);
            }
            finally {
                this.openJob = null;
            }
        }
    }

    protected abstract CompletableFuture<TBlock> createBlockDevice();

    protected void handleDataAccess() {
    }

    private boolean allocateDevice(VMContext context) {
        if (!context.getMemoryAllocator().claimMemory(4096)) {
            return false;
        }
        this.device = new VirtIOBlockDevice(context.getMemoryMap(), this.readonly);
        this.setOpenJob((CompletableFuture<Void>)this.createBlockDevice().thenAcceptAsync(blockDevice -> {
            try {
                ListenableBlockDevice listenableData = new ListenableBlockDevice((BlockDevice)blockDevice);
                listenableData.onAccess.add(this::handleDataAccess);
                this.device.setBlock((BlockDevice)listenableData);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, (Executor)WORKERS));
        return true;
    }

    private void closeDevice() {
        this.joinOpenJob();
        if (this.device == null) {
            return;
        }
        try {
            this.device.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        this.device = null;
    }

    private static final class ListenableBlockDevice
    implements BlockDevice {
        private final BlockDevice inner;
        public final Event onAccess = new Event();

        private ListenableBlockDevice(BlockDevice inner) {
            this.inner = inner;
        }

        public boolean isReadonly() {
            return this.inner.isReadonly();
        }

        public long getCapacity() {
            return this.inner.getCapacity();
        }

        public InputStream getInputStream(long offset) {
            ListenableInputStream stream = new ListenableInputStream(this.inner.getInputStream(offset));
            stream.onAccess.add(this.onAccess);
            return stream;
        }

        public OutputStream getOutputStream(long offset) {
            ListenableOutputStream stream = new ListenableOutputStream(this.inner.getOutputStream(offset));
            stream.onAccess.add(this.onAccess);
            return stream;
        }

        public void flush() {
            this.inner.flush();
        }

        public void close() throws IOException {
            this.inner.close();
        }
    }

    private static final class ListenableOutputStream
    extends OutputStream {
        private final OutputStream inner;
        public final Event onAccess = new Event();

        private ListenableOutputStream(OutputStream inner) {
            this.inner = inner;
        }

        @Override
        public void write(int b) throws IOException {
            this.onAccess();
            this.inner.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.onAccess();
            this.inner.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.onAccess();
            this.inner.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.inner.flush();
        }

        @Override
        public void close() throws IOException {
            this.inner.close();
        }

        private void onAccess() {
            this.onAccess.run();
        }
    }

    private static final class ListenableInputStream
    extends InputStream {
        private final InputStream inner;
        public final Event onAccess = new Event();

        private ListenableInputStream(InputStream inner) {
            this.inner = inner;
        }

        @Override
        public int read() throws IOException {
            this.onAccess();
            return this.inner.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.onAccess();
            return this.inner.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.onAccess();
            return this.inner.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            this.onAccess();
            return this.inner.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.inner.available();
        }

        @Override
        public void close() throws IOException {
            this.inner.close();
        }

        @Override
        public synchronized void mark(int limit) {
            this.inner.mark(limit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.onAccess();
            this.inner.reset();
        }

        @Override
        public boolean markSupported() {
            return this.inner.markSupported();
        }

        private void onAccess() {
            this.onAccess.run();
        }
    }
}

