/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.vm.item;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import li.cil.oc2.common.bus.device.vm.item.AbstractBlockStorageDevice;
import li.cil.oc2.common.config.AsyncConfig;
import li.cil.oc2.common.serialization.BlobStorage;
import li.cil.oc2.common.util.BlockLocation;
import li.cil.oc2.common.util.SoundEvents;
import li.cil.oc2.common.util.ThrottledSoundEmitter;
import li.cil.sedna.device.block.ByteBufferBlockDevice;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HardDriveDevice
extends AbstractBlockStorageDevice<ByteBufferBlockDevice, ItemStack> {
    private final int size;
    private final ThrottledSoundEmitter soundEmitter;
    private static final Logger LOGGER = LogManager.getLogger();

    public HardDriveDevice(ItemStack identity, int size, boolean readonly, Supplier<Optional<BlockLocation>> location) {
        super(identity, readonly);
        this.size = size;
        this.soundEmitter = new ThrottledSoundEmitter(location, (SoundEvent)SoundEvents.HDD_ACCESS.get()).withMinInterval(Duration.ofSeconds(1L));
    }

    @Override
    protected CompletableFuture<ByteBufferBlockDevice> createBlockDevice() {
        this.blobHandle = BlobStorage.validateHandle(this.blobHandle);
        boolean useAsync = false;
        try {
            if (AsyncConfig.SERVER != null) {
                useAsync = (Boolean)AsyncConfig.SERVER.asyncStorageOperations.get();
            }
        }
        catch (IllegalStateException e) {
            LOGGER.trace("Config not loaded yet, using default async storage operations setting");
        }
        if (useAsync) {
            return BlobStorage.getOrOpenAsync(this.blobHandle).thenApplyAsync(channel -> {
                try {
                    boolean debug = false;
                    try {
                        if (AsyncConfig.SERVER != null) {
                            debug = (Boolean)AsyncConfig.SERVER.enableSuperDebug.get();
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    if (debug) {
                        LOGGER.debug("Mapping buffer for blob: {}", (Object)this.blobHandle);
                    }
                    MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, this.size);
                    return ByteBufferBlockDevice.wrap((ByteBuffer)buffer, (boolean)this.readonly);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to map buffer for blob: " + String.valueOf(this.blobHandle), (Throwable)e);
                    throw new CompletionException(e);
                }
            }, (Executor)WORKERS);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                FileChannel channel = BlobStorage.getOrOpen(this.blobHandle);
                MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, this.size);
                return ByteBufferBlockDevice.wrap((ByteBuffer)buffer, (boolean)this.readonly);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create block device", (Throwable)e);
                throw new CompletionException("Failed to create block device", e);
            }
        }, WORKERS);
    }

    @Override
    protected void handleDataAccess() {
        this.soundEmitter.play();
    }
}

