/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.config.common;

import java.util.UUID;
import li.cil.oc2.common.config.Config;
import net.minecraftforge.common.ForgeConfigSpec;

public class AdminSpec {
    public final ForgeConfigSpec.ConfigValue<String> fakePlayerUUID;
    public final ForgeConfigSpec.IntValue projectorAverageMaxBytesPerSecond;
    public final ForgeConfigSpec.IntValue ethernetFrameTimeToLive;
    public final ForgeConfigSpec.IntValue hubEthernetFrameTimeToLive;

    AdminSpec(ForgeConfigSpec.Builder builder) {
        this.fakePlayerUUID = builder.comment("The UUID that the mod will use for it's fake player").define("fakePlayerUUID", (Object)"e39dd9a7-514f-4a2d-aa5e-b6030621416d");
        builder.push("network");
        this.projectorAverageMaxBytesPerSecond = builder.comment("The maximum number of bytes a projector will send per second on average").defineInRange("projectorAverageMaxBytesPerSecond", 163840, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("virtual_network");
        this.ethernetFrameTimeToLive = builder.comment("The time to live of an ethernet frame sent over the virtual network").defineInRange("ethernetFrameTimeToLive", 12, 0, Integer.MAX_VALUE);
        this.hubEthernetFrameTimeToLive = builder.comment("The time to live of an ethernet frame sent over the virtual network to a hub").defineInRange("hubEthernetFrameTimeToLive", 32, 0, Integer.MAX_VALUE);
        builder.pop();
    }

    public void loadValues() {
        Config.fakePlayerUUID = UUID.fromString((String)this.fakePlayerUUID.get());
        Config.projectorAverageMaxBytesPerSecond = (Integer)this.projectorAverageMaxBytesPerSecond.get();
        Config.ethernetFrameTimeToLive = (Integer)this.ethernetFrameTimeToLive.get();
        Config.hubEthernetFramesPerTick = (Integer)this.ethernetFrameTimeToLive.get();
    }
}

