/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.config.common;

import li.cil.oc2.common.config.Config;
import net.minecraftforge.common.ForgeConfigSpec;

public class EnergySpec {
    public final ForgeConfigSpec.DoubleValue busCableEnergyPerTick;
    public final ForgeConfigSpec.DoubleValue busInterfaceEnergyPerTick;
    public final ForgeConfigSpec.IntValue computerEnergyPerTick;
    public final ForgeConfigSpec.IntValue computerEnergyStorage;
    public final ForgeConfigSpec.IntValue chargerEnergyPerTick;
    public final ForgeConfigSpec.IntValue chargerEnergyStorage;
    public final ForgeConfigSpec.IntValue projectorEnergyPerTick;
    public final ForgeConfigSpec.IntValue projectorEnergyStorage;
    public final ForgeConfigSpec.IntValue monitorEnergyPerTick;
    public final ForgeConfigSpec.IntValue monitorEnergyStorage;
    public final ForgeConfigSpec.IntValue cardCageEnergyPerTick;
    public final ForgeConfigSpec.IntValue cardCageEnergyStorage;
    public final ForgeConfigSpec.IntValue gatewayEnergyPerPacket;
    public final ForgeConfigSpec.IntValue gatewayEnergyStorage;
    public final ForgeConfigSpec.IntValue robotEnergyPerTick;
    public final ForgeConfigSpec.IntValue robotEnergyStorage;
    public final ForgeConfigSpec.DoubleValue memoryEnergyPerMegabytePerTick;
    public final ForgeConfigSpec.DoubleValue hardDriveEnergyPerMegabytePerTick;
    public final ForgeConfigSpec.DoubleValue cpuEnergyPerMegahertzPerTick;
    public final ForgeConfigSpec.IntValue redstoneInterfaceCardEnergyPerTick;
    public final ForgeConfigSpec.IntValue networkInterfaceEnergyPerTick;
    public final ForgeConfigSpec.IntValue fileImportExportCardEnergyPerTick;
    public final ForgeConfigSpec.IntValue soundCardEnergyPerTick;
    public final ForgeConfigSpec.IntValue blockOperationsModuleEnergyPerTick;
    public final ForgeConfigSpec.IntValue inventoryOperationsModuleEnergyPerTick;
    public final ForgeConfigSpec.IntValue networkTunnelEnergyPerTick;

    EnergySpec(ForgeConfigSpec.Builder builder) {
        builder.push("blocks");
        this.busCableEnergyPerTick = builder.comment("The amount of energy consumed per tick by a bus cable").defineInRange("busCableEnergyPerTick", 0.05, 0.0, Double.MAX_VALUE);
        this.busInterfaceEnergyPerTick = builder.comment("The amount of energy consumed per tick by a bus interface").defineInRange("busInterfaceEnergyPerTick", 0.05, 0.0, Double.MAX_VALUE);
        this.computerEnergyPerTick = builder.comment("The amount of energy consumed per tick by a computer").defineInRange("computerEnergyPerTick", 10, 0, Integer.MAX_VALUE);
        this.computerEnergyStorage = builder.comment("The amount of energy stored in a computer").defineInRange("computerEnergyStorage", 2000, 0, Integer.MAX_VALUE);
        this.chargerEnergyPerTick = builder.comment("The amount of energy consumed per tick by a charger").defineInRange("chargerEnergyPerTick", 2500, 0, Integer.MAX_VALUE);
        this.chargerEnergyStorage = builder.comment("The amount of energy stored in a charger").defineInRange("chargerEnergyStorage", 10000, 0, Integer.MAX_VALUE);
        this.projectorEnergyPerTick = builder.comment("The amount of energy consumed per tick by a projector").defineInRange("projectorEnergyPerTick", 20, 0, Integer.MAX_VALUE);
        this.projectorEnergyStorage = builder.comment("The amount of energy stored in a projector").defineInRange("projectorEnergyStorage", 2000, 0, Integer.MAX_VALUE);
        this.monitorEnergyPerTick = builder.comment("The amount of energy consumed per tick by a monitor").defineInRange("monitorEnergyPerTick", 15, 0, Integer.MAX_VALUE);
        this.monitorEnergyStorage = builder.comment("The amount of energy stored in a monitor").defineInRange("monitorEnergyStorage", 2000, 0, Integer.MAX_VALUE);
        this.cardCageEnergyPerTick = builder.comment("The amount of energy consumed per tick by a card cage").defineInRange("cardCageEnergyPerTick", 20, 0, Integer.MAX_VALUE);
        this.cardCageEnergyStorage = builder.comment("The amount of energy stored in a card cage").defineInRange("cardCageEnergyStorage", 2000, 0, Integer.MAX_VALUE);
        this.gatewayEnergyPerPacket = builder.comment("The amount of energy consumed per packet by a gateway").defineInRange("gatewayEnergyPerPacket", 20, 0, Integer.MAX_VALUE);
        this.gatewayEnergyStorage = builder.comment("The amount of energy stored in a gateway").defineInRange("gatewayEnergyStorage", 2000, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("entities");
        this.robotEnergyPerTick = builder.comment("The amount of energy consumed per tick by a robot").defineInRange("gatewayEnergyStorage", 5, 0, Integer.MAX_VALUE);
        this.robotEnergyStorage = builder.comment("The amount of energy stored in a robot").defineInRange("robotEnergyStorage", 750000, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("items");
        this.memoryEnergyPerMegabytePerTick = builder.comment("The amount of energy consumed per megabyte per tick for memory modules").defineInRange("memoryEnergyPerMegabytePerTick", 0.05, 0.0, Double.MAX_VALUE);
        this.hardDriveEnergyPerMegabytePerTick = builder.comment("The amount of energy consumed per megabyte per tick for hard drive modules").defineInRange("hardDriveEnergyPerMegabytePerTick", 1.0, 0.0, Double.MAX_VALUE);
        this.cpuEnergyPerMegahertzPerTick = builder.comment("The amount of energy consumed per megahertz per tick for CPU modules").defineInRange("cpuEnergyPerMegahertzPerTick", 0.1, 0.0, Double.MAX_VALUE);
        this.redstoneInterfaceCardEnergyPerTick = builder.comment("The amount of energy consumed per tick for redstone interface cards").defineInRange("redstoneInterfaceCardEnergyPerTick", 1, 0, Integer.MAX_VALUE);
        this.networkInterfaceEnergyPerTick = builder.comment("The amount of energy consumed per tick for network interface cards").defineInRange("redstoneInterfaceCardEnergyPerTick", 1, 0, Integer.MAX_VALUE);
        this.fileImportExportCardEnergyPerTick = builder.comment("The amount of energy consumed per tick for file import/export cards").defineInRange("fileImportExportCardEnergyPerTick", 1, 0, Integer.MAX_VALUE);
        this.soundCardEnergyPerTick = builder.comment("The amount of energy consumed per tick for sound cards").defineInRange("soundCardEnergyPerTick", 1, 0, Integer.MAX_VALUE);
        this.blockOperationsModuleEnergyPerTick = builder.comment("The amount of energy consumed per tick for block operations modules").defineInRange("blockOperationsModuleEnergyPerTick", 2, 0, Integer.MAX_VALUE);
        this.inventoryOperationsModuleEnergyPerTick = builder.comment("The amount of energy consumed per tick for inventory operations modules").defineInRange("inventoryOperationsModuleEnergyPerTick", 1, 0, Integer.MAX_VALUE);
        this.networkTunnelEnergyPerTick = builder.comment("The amount of energy consumed per tick for network tunnels").defineInRange("networkTunnelEnergyPerTick", 2, 0, Integer.MAX_VALUE);
        builder.pop();
    }

    public void loadValues() {
        Config.busCableEnergyPerTick = (Double)this.busCableEnergyPerTick.get();
        Config.busInterfaceEnergyPerTick = (Double)this.busInterfaceEnergyPerTick.get();
        Config.computerEnergyPerTick = (Integer)this.computerEnergyPerTick.get();
        Config.computerEnergyStorage = (Integer)this.computerEnergyStorage.get();
        Config.chargerEnergyPerTick = (Integer)this.chargerEnergyPerTick.get();
        Config.chargerEnergyStorage = (Integer)this.chargerEnergyStorage.get();
        Config.projectorEnergyPerTick = (Integer)this.projectorEnergyPerTick.get();
        Config.projectorEnergyStorage = (Integer)this.projectorEnergyStorage.get();
        Config.monitorEnergyPerTick = (Integer)this.monitorEnergyPerTick.get();
        Config.monitorEnergyStorage = (Integer)this.monitorEnergyStorage.get();
        Config.cardCageEnergyPerTick = (Integer)this.cardCageEnergyPerTick.get();
        Config.cardCageEnergyStorage = (Integer)this.cardCageEnergyStorage.get();
        Config.gatewayEnergyPerPacket = (Integer)this.gatewayEnergyPerPacket.get();
        Config.gatewayEnergyStorage = (Integer)this.gatewayEnergyStorage.get();
        Config.robotEnergyPerTick = (Integer)this.robotEnergyPerTick.get();
        Config.robotEnergyStorage = (Integer)this.robotEnergyStorage.get();
        Config.memoryEnergyPerMegabytePerTick = (Double)this.memoryEnergyPerMegabytePerTick.get();
        Config.hardDriveEnergyPerMegabytePerTick = (Double)this.hardDriveEnergyPerMegabytePerTick.get();
        Config.cpuEnergyPerMegahertzPerTick = (Double)this.cpuEnergyPerMegahertzPerTick.get();
        Config.redstoneInterfaceCardEnergyPerTick = (Integer)this.redstoneInterfaceCardEnergyPerTick.get();
        Config.networkInterfaceEnergyPerTick = (Integer)this.networkInterfaceEnergyPerTick.get();
        Config.fileImportExportCardEnergyPerTick = (Integer)this.fileImportExportCardEnergyPerTick.get();
        Config.soundCardEnergyPerTick = (Integer)this.soundCardEnergyPerTick.get();
        Config.blockOperationsModuleEnergyPerTick = (Integer)this.blockOperationsModuleEnergyPerTick.get();
        Config.inventoryOperationsModuleEnergyPerTick = (Integer)this.inventoryOperationsModuleEnergyPerTick.get();
    }
}

