/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.inet;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.Random;
import li.cil.oc2.api.inet.LayerParameters;
import li.cil.oc2.api.inet.layer.LinkLocalLayer;
import li.cil.oc2.api.inet.layer.NetworkLayer;
import li.cil.oc2.common.inet.AddressParseException;
import li.cil.oc2.common.inet.InetUtils;
import li.cil.oc2.common.inet.MacAddress;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DefaultLinkLocalLayer
implements LinkLocalLayer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random random = new Random();
    private static final short MAC_PREFIX = 24273;
    private static final short PROTOCOL_ARP = 2054;
    private static final short HW_TYPE_ETHERNET = 1;
    private static final int ARP_MESSAGE_SIZE = 28;
    private static final int ARP_ADDRESS_TYPE = 67584;
    private static final short ARP_ADDRESSES_SIZES = 1540;
    private static final short ARP_REQUEST = 1;
    private static final short ARP_RESPONSE = 2;
    private static final int IP_VER4 = 4;
    private static final int IP_VER6 = 6;
    private static final String MAC_ADDRESS_TAG = "MACAddress";
    private static final String IPv4_ADDRESS_TAG = "IPv4Address";
    private final NetworkLayer networkLayer;
    private MacAddress myMacAddress = new MacAddress(24273, random.nextInt());
    private int myIpV4Address = -1;
    private short cardMacPrefix = (short)-1;
    private int cardMacAddress = -1;
    private int cardIpAddress = -1;
    private boolean needArpResponse = false;

    public DefaultLinkLocalLayer(LayerParameters layerParameters, NetworkLayer networkLayer) {
        layerParameters.getSavedState().ifPresent(tag -> {
            if (tag instanceof CompoundTag) {
                String macAddressString;
                CompoundTag layerState = (CompoundTag)tag;
                String ipAddressString = layerState.m_128461_(IPv4_ADDRESS_TAG);
                if (!ipAddressString.isEmpty()) {
                    try {
                        this.myIpV4Address = InetUtils.parseIpv4Address(ipAddressString);
                    }
                    catch (AddressParseException exception) {
                        LOGGER.error("Failed to parse internet adapter IPv4 address", (Throwable)exception);
                    }
                }
                if (!(macAddressString = layerState.m_128461_(MAC_ADDRESS_TAG)).isEmpty()) {
                    try {
                        this.myMacAddress = InetUtils.parseMacAddress(macAddressString);
                    }
                    catch (AddressParseException exception) {
                        LOGGER.error("Failed to parse internet adapter MAC address from NBT", (Throwable)exception);
                    }
                }
            }
        });
        this.networkLayer = networkLayer;
    }

    private void prepareEthernetHeader(ByteBuffer frame, short protocol) {
        frame.putShort(this.cardMacPrefix);
        frame.putInt(this.cardMacAddress);
        frame.putShort(this.myMacAddress.prefix());
        frame.putInt(this.myMacAddress.address());
        frame.putShort(protocol);
    }

    @Override
    public Optional<Tag> onSave() {
        CompoundTag layerState = new CompoundTag();
        if (this.myIpV4Address != -1) {
            String ipAddressString = InetUtils.ipv4AddressToString(this.myIpV4Address);
            layerState.m_128359_(IPv4_ADDRESS_TAG, ipAddressString);
        }
        layerState.m_128359_(MAC_ADDRESS_TAG, InetUtils.macAddressToString(this.myMacAddress));
        this.networkLayer.onSave().ifPresent(networkLayerState -> layerState.m_128365_("Network", networkLayerState));
        return Optional.of(layerState);
    }

    @Override
    public void onStop() {
        this.networkLayer.onStop();
    }

    @Override
    public boolean receiveEthernetFrame(ByteBuffer frame) {
        if (this.needArpResponse) {
            this.needArpResponse = false;
            this.prepareEthernetHeader(frame, (short)2054);
            frame.putInt(67584);
            frame.putShort((short)1540);
            frame.putShort((short)2);
            frame.putShort(this.myMacAddress.prefix());
            frame.putInt(this.myMacAddress.address());
            frame.putInt(this.myIpV4Address);
            frame.putShort(this.cardMacPrefix);
            frame.putInt(this.cardMacAddress);
            frame.putInt(this.cardIpAddress);
            frame.position(frame.position() - 14 - 28);
            LOGGER.trace("ARP message sent");
        } else {
            int version;
            frame.position(frame.position() + 14);
            int protocol = this.networkLayer.receivePacket(frame);
            if (protocol == 0) {
                return false;
            }
            if (protocol == 2048 && (version = Byte.toUnsignedInt(frame.get(frame.position())) >>> 4) == 6) {
                protocol = -31011;
            }
            frame.position(frame.position() - 14);
            this.prepareEthernetHeader(frame, (short)protocol);
            frame.position(frame.position() - 14);
            LOGGER.trace("IP message sent");
        }
        return true;
    }

    @Override
    public void sendEthernetFrame(ByteBuffer frame) {
        if (frame.remaining() < 14) {
            LOGGER.trace("Ethernet header too low");
            return;
        }
        short dstMacPrefix = frame.getShort();
        int dstMacAddress = frame.getInt();
        short srcMacPrefix = frame.getShort();
        int srcMacAddress = frame.getInt();
        short protocol = frame.getShort();
        if (protocol == 2054) {
            LOGGER.trace("ARP message received");
            if (frame.remaining() < 28) {
                return;
            }
            int hwAndProtocolAddressesTypes = frame.getInt();
            if (hwAndProtocolAddressesTypes != 67584) {
                LOGGER.trace("Wrong ARP address type, drop");
                return;
            }
            short addressesSizes = frame.getShort();
            if (addressesSizes != 1540) {
                LOGGER.trace("Wrong ARP address size, drop");
                return;
            }
            short messageType = frame.getShort();
            if (messageType != 1) {
                LOGGER.trace("Not an ARP request, drop");
                return;
            }
            short senderMacPrefix = frame.getShort();
            int senderMacAddress = frame.getInt();
            if (senderMacPrefix != srcMacPrefix || senderMacAddress != srcMacAddress) {
                LOGGER.trace("Wrong sender, drop");
                return;
            }
            this.cardIpAddress = frame.getInt();
            frame.getShort();
            frame.getInt();
            this.myIpV4Address = frame.getInt();
            this.cardMacPrefix = senderMacPrefix;
            this.cardMacAddress = senderMacAddress;
            this.needArpResponse = true;
        } else {
            LOGGER.trace("Network message received");
            this.networkLayer.sendPacket(protocol, frame);
        }
    }
}

