/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.inet;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import li.cil.oc2.api.inet.InternetManager;
import li.cil.oc2.api.inet.LayerParameters;
import li.cil.oc2.api.inet.layer.SessionLayer;
import li.cil.oc2.api.inet.session.DatagramSession;
import li.cil.oc2.api.inet.session.EchoSession;
import li.cil.oc2.api.inet.session.Session;
import li.cil.oc2.api.inet.session.StreamSession;
import li.cil.oc2.common.config.Config;
import li.cil.oc2.common.inet.ReadySessions;
import li.cil.oc2.common.inet.SocketManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class DefaultSessionLayer
implements SessionLayer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Executor executor = Executors.newSingleThreadExecutor(runnable -> new Thread(runnable, "internet/blocking-session"));
    private final AtomicReference<EchoResponse> echoResponse = new AtomicReference<Object>(null);
    private final ReadySessions readySessions = new ReadySessions();
    private final SocketManager socketManager;

    public DefaultSessionLayer(LayerParameters layerParameters) {
        InternetManager internetManager = layerParameters.getInternetManager();
        this.socketManager = SocketManager.attach(internetManager);
    }

    @Override
    public void onStop() {
        this.socketManager.detach();
    }

    @Override
    public void receiveSession(SessionLayer.Receiver receiver) {
        EchoResponse pending = this.echoResponse.getAndSet(null);
        if (pending != null) {
            ByteBuffer data = receiver.receive(pending.session);
            assert (data != null);
            data.put(pending.payload);
            data.flip();
            return;
        }
        boolean somethingConnected = this.processQueue(this.readySessions.getToConnect(), session -> {
            if (session instanceof StreamSession) {
                StreamSession streamSession = (StreamSession)session;
                LOGGER.trace("Connected {}", session);
                if (session.getState() != Session.States.NEW) {
                    return false;
                }
                receiver.receive(streamSession);
                try {
                    SocketChannel channel = this.getChannel(streamSession);
                    channel.finishConnect();
                    streamSession.connect();
                    return true;
                }
                catch (ConnectException exception) {
                    LOGGER.trace("Connection rejected for {}", session);
                    this.closeSession((Session)session);
                    return true;
                }
                catch (IOException exception) {
                    LOGGER.error("Error on socket.finishConnect()", (Throwable)exception);
                    this.closeSession((Session)session);
                    return true;
                }
            }
            return false;
        });
        if (somethingConnected) {
            return;
        }
        this.processQueue(this.readySessions.getToRead(), session -> {
            if (session instanceof DatagramSession) {
                DatagramSession datagramSession = (DatagramSession)session;
                LOGGER.trace("Datagram received");
                DatagramChannel channel = this.getChannel(datagramSession);
                try {
                    ByteBuffer datagram = receiver.receive(datagramSession);
                    assert (datagram != null);
                    SocketAddress address = channel.receive(datagram);
                    if (address == null) {
                        return false;
                    }
                    if (Config.useSynchronisedNAT && !address.equals(datagramSession.getDestination())) {
                        return false;
                    }
                    datagram.flip();
                    return true;
                }
                catch (IOException exception) {
                    LOGGER.error("Trying to read datagram socket", (Throwable)exception);
                    LOGGER.trace("Datagram received");
                }
            } else if (session instanceof StreamSession) {
                StreamSession streamSession = (StreamSession)session;
                LOGGER.trace("Stream received");
                ByteBuffer stream = receiver.receive(streamSession);
                try {
                    SocketChannel channel = this.getChannel(streamSession);
                    assert (stream != null);
                    assert (false);
                    int read = channel.read(stream);
                    LOGGER.trace("Read from real world: {}", (Object)read);
                    if (read == -1) {
                        this.closeSession((Session)session);
                    }
                    return true;
                }
                catch (IOException exception) {
                    LOGGER.error("Trying to read stream socket", (Throwable)exception);
                }
            }
            return false;
        });
    }

    public native byte[] sendICMP(byte[] var1, byte[] var2, int var3, int var4);

    @Override
    public void sendSession(Session session, @Nullable ByteBuffer data) {
        if (session instanceof EchoSession) {
            EchoSession echoSession = (EchoSession)session;
            if (data == null) {
                return;
            }
            InetAddress address = session.getDestination().getAddress();
            byte[] payload = new byte[data.remaining()];
            int size = data.remaining();
            data.get(payload);
            byte[] responseData = this.sendICMP(address.getAddress(), payload, size, Config.defaultEchoRequestTimeoutMs);
            if (responseData != null) {
                EchoResponse response = new EchoResponse(ByteBuffer.wrap(responseData), echoSession);
                this.echoResponse.set(response);
            }
        } else if (session instanceof DatagramSession) {
            DatagramSession datagramSession = (DatagramSession)session;
            try {
                switch (session.getState()) {
                    case NEW: {
                        DatagramChannel channel = this.socketManager.createDatagramChannel(datagramSession, this.readySessions);
                        datagramSession.setAttachment(channel);
                        LOGGER.trace("Open datagram socket {}", (Object)session.getDestination());
                    }
                    case ESTABLISHED: {
                        LOGGER.trace("Send datagram");
                        DatagramChannel channel = this.getChannel(datagramSession);
                        assert (data != null);
                        channel.send(data, session.getDestination());
                        break;
                    }
                    case EXPIRED: {
                        this.closeSession(session);
                        LOGGER.trace("Close datagram socket {}", (Object)session.getDestination());
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Datagram session failure", (Throwable)e);
                session.close();
            }
        } else if (session instanceof StreamSession) {
            StreamSession streamSession = (StreamSession)session;
            try {
                switch (session.getState()) {
                    case NEW: {
                        SocketChannel channel = this.socketManager.createStreamChannel(streamSession, this.readySessions);
                        streamSession.setAttachment(channel);
                        channel.connect(streamSession.getDestination());
                        LOGGER.trace("Open stream socket {}", (Object)streamSession.getDestination());
                        break;
                    }
                    case ESTABLISHED: {
                        SocketChannel channel = this.getChannel(streamSession);
                        assert (data != null);
                        channel.write(data);
                        break;
                    }
                    case EXPIRED: 
                    case FINISH: {
                        this.closeSession(session);
                        LOGGER.trace("Close stream socket {}", (Object)session.getDestination());
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Stream session failure", (Throwable)e);
                session.close();
            }
        } else {
            session.close();
        }
    }

    private boolean processQueue(Queue<Session> queue, Function<Session, Boolean> action) {
        Session session;
        do {
            if ((session = queue.poll()) != null) continue;
            return false;
        } while (session.isClosed() || !action.apply(session).booleanValue());
        return true;
    }

    private void closeSession(Session session) {
        try {
            this.getChannel(session).close();
            if (!session.isClosed()) {
                session.close();
            }
        }
        catch (IOException exception) {
            LOGGER.error("Error on closing channel", (Throwable)exception);
        }
    }

    private Object getExistingUserdata(Session session) {
        Object channel = session.getAttachment();
        assert (channel != null);
        return channel;
    }

    private SocketChannel getChannel(StreamSession session) {
        return (SocketChannel)this.getExistingUserdata(session);
    }

    private DatagramChannel getChannel(DatagramSession session) {
        return (DatagramChannel)this.getExistingUserdata(session);
    }

    private SelectableChannel getChannel(Session session) {
        return (SelectableChannel)this.getExistingUserdata(session);
    }

    private static final class EchoResponse {
        final byte[] payload;
        final EchoSession session;

        public EchoResponse(ByteBuffer payload, EchoSession session) {
            this.payload = new byte[payload.remaining()];
            payload.get(this.payload);
            this.session = session;
        }
    }
}

