/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.inet;

import java.net.InetSocketAddress;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import li.cil.oc2.api.inet.session.Session;
import li.cil.oc2.common.inet.InetUtils;
import li.cil.oc2.common.inet.SessionDiscriminator;

public abstract class SessionBase
implements Session {
    private static final AtomicLong idGenerator = new AtomicLong();
    private final long id = idGenerator.getAndIncrement();
    private final InetSocketAddress destination;
    private Instant lastUpdateTime = Instant.now();
    @Nullable
    private Object attachment;

    public SessionBase(int ipAddress, short port) {
        this.destination = new InetSocketAddress(InetUtils.toJavaInetAddress(ipAddress), Short.toUnsignedInt(port));
    }

    @Override
    public long getId() {
        return this.id;
    }

    public void update() {
        this.lastUpdateTime = Instant.now();
    }

    @Override
    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    @Nullable
    public Object getAttachment() {
        return this.attachment;
    }

    @Override
    public void setAttachment(@Nullable Object userdata) {
        this.attachment = userdata;
    }

    @Override
    public InetSocketAddress getDestination() {
        return this.destination;
    }

    public abstract SessionDiscriminator<?> getDiscriminator();

    public abstract void expire();
}

