/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.network.message;

import java.nio.ByteBuffer;
import li.cil.oc2.common.blockentity.MonitorBlockEntity;
import li.cil.oc2.common.network.MessageUtils;
import li.cil.oc2.common.network.message.AbstractMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public final class MonitorFramebufferMessage
extends AbstractMessage {
    private BlockPos pos;
    private ByteBuffer frame;

    public MonitorFramebufferMessage(BlockPos projectorPos, ByteBuffer frame) {
        this.pos = projectorPos;
        this.frame = frame;
    }

    public MonitorFramebufferMessage(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.frame = ByteBuffer.allocateDirect(buffer.m_130242_());
        buffer.readBytes(this.frame);
        this.frame.flip();
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130130_(this.frame.limit());
        buffer.writeBytes(this.frame);
        this.frame.position(0);
    }

    @Override
    protected void handleMessage(NetworkEvent.Context context) {
        MessageUtils.withClientBlockEntityAt(this.pos, MonitorBlockEntity.class, monitor -> monitor.applyNextFrameClient(this.frame));
    }
}

