/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.util;

import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class IntegerSpace {
    private final NavigableMap<Integer, Integer> ranges = new TreeMap<Integer, Integer>();

    public final boolean put(int element) {
        return this.put(element, element);
    }

    public final boolean put(int begin, int end) {
        if (end < begin) {
            return this.put(end, begin);
        }
        this.ranges.subMap(begin, false, end, false).entrySet().removeIf(range -> (Integer)range.getKey() > begin && (Integer)range.getValue() < end);
        Map.Entry<Integer, Integer> floorBegin = this.ranges.floorEntry(begin);
        Map.Entry<Integer, Integer> higherEnd = this.ranges.ceilingEntry(end);
        if (floorBegin != null && floorBegin.getKey() <= begin && floorBegin.getValue() >= end) {
            return false;
        }
        if (floorBegin != null && higherEnd != null && floorBegin.getKey() <= begin && floorBegin.getValue() + 1 >= begin && higherEnd.getKey() - 1 <= end && higherEnd.getValue() >= end) {
            this.ranges.entrySet().remove(higherEnd);
            this.ranges.put(floorBegin.getKey(), higherEnd.getValue());
        } else if (higherEnd != null && higherEnd.getKey() - 1 <= end && higherEnd.getValue() >= end) {
            this.ranges.entrySet().remove(higherEnd);
            this.ranges.put(begin, higherEnd.getValue());
        } else if (floorBegin != null && floorBegin.getKey() <= begin && floorBegin.getValue() + 1 >= begin) {
            this.ranges.put(floorBegin.getKey(), end);
        } else {
            this.ranges.put(begin, end);
        }
        return true;
    }

    public final boolean contains(int element) {
        Map.Entry<Integer, Integer> floorRange = this.ranges.floorEntry(element);
        return floorRange != null && element >= floorRange.getKey() && element <= floorRange.getValue();
    }

    public final boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    public final int rangeCount() {
        return this.ranges.size();
    }

    public final int count() {
        return this.ranges.entrySet().stream().map(range -> (Integer)range.getValue() - (Integer)range.getKey() + 1).reduce(0, Integer::sum);
    }

    protected void elementToString(StringBuilder builder, int element) {
        builder.append(element);
    }

    private void appendRangeToString(StringBuilder builder, Map.Entry<Integer, Integer> range) {
        int begin = range.getKey();
        int end = range.getValue();
        this.elementToString(builder, begin);
        if (begin != end) {
            builder.append('-');
            this.elementToString(builder, range.getValue());
        }
    }

    public String toString() {
        Iterator iterator = this.ranges.entrySet().iterator();
        if (iterator.hasNext()) {
            StringBuilder builder = new StringBuilder();
            builder.append('[');
            Map.Entry<Integer, Integer> first = iterator.next();
            this.appendRangeToString(builder, first);
            while (iterator.hasNext()) {
                builder.append(", ");
                Map.Entry<Integer, Integer> range = iterator.next();
                this.appendRangeToString(builder, range);
            }
            builder.append(']');
            return builder.toString();
        }
        return "[]";
    }
}

