/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.util;

import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.function.Supplier;
import li.cil.oc2.api.bus.device.provider.BlockDeviceQuery;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.common.util.BlockLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class LocationSupplierUtils {
    public static Supplier<Optional<BlockLocation>> of(BlockEntity blockEntity) {
        return () -> BlockLocation.ofOptional(blockEntity);
    }

    public static Supplier<Optional<BlockLocation>> of(Entity entity) {
        return () -> BlockLocation.ofOptional(entity);
    }

    public static Supplier<Optional<BlockLocation>> of(BlockDeviceQuery query) {
        Optional<BlockLocation> location = Optional.of(new BlockLocation(new WeakReference<LevelAccessor>(query.getLevel()), query.getQueryPosition()));
        return () -> location;
    }

    public static Supplier<Optional<BlockLocation>> of(ItemDeviceQuery query) {
        Optional<BlockEntity> blockEntity = query.getContainerBlockEntity();
        if (blockEntity.isPresent()) {
            return () -> BlockLocation.ofOptional((BlockEntity)blockEntity.get());
        }
        Optional<Entity> entity = query.getContainerEntity();
        if (entity.isPresent()) {
            return () -> BlockLocation.ofOptional((Entity)entity.get());
        }
        return Optional::empty;
    }
}

