/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm.terminal.escapes.csi;

import java.util.Arrays;
import li.cil.oc2.common.vm.terminal.Terminal;
import li.cil.oc2.common.vm.terminal.escapes.csi.CSISequenceHandler;
import li.cil.oc2.common.vm.terminal.escapes.csi.CSIState;

public class CH11
extends CSISequenceHandler {
    public CH11(Terminal terminal) {
        super(terminal);
    }

    @Override
    public void execute(int[] args, int argsCount, CSIState state) {
        int chars = Math.max(args[0], 1);
        if (state.space) {
            for (int i = 0; i <= this.terminal.y; ++i) {
                this.shiftLeft(chars, i);
            }
        } else if (chars >= 80) {
            this.terminal.clearLine(this.terminal.y);
        } else {
            this.shiftRight(chars);
        }
    }

    private void shiftLeft(int chars, int y) {
        int startIndex = this.terminal.currentPrivateModeState.isAltBufferEnabled() ? y * 80 : (y + (this.terminal.lastRowToDisplayMax - 24)) * 80;
        int count = 80 - chars;
        int endIndex = startIndex + count;
        Terminal.ColorData c = switch (this.terminal.currentBackgroundColorMode) {
            case Terminal.ColorMode.SIXTEEN_COLOR -> this.terminal.sixteenColor;
            case Terminal.ColorMode.TWO_FIFTY_SIX_COLOR -> this.terminal.twoFiftySixColor;
            case Terminal.ColorMode.TRUE_COLOR -> this.terminal.backgroundColor;
            case Terminal.ColorMode.SIXTEEN_COLOR_BRIGHT -> this.terminal.sixteenColorBright;
            default -> Terminal.DEFAULT_BACKGROUND_COLOR;
        };
        if (this.terminal.currentPrivateModeState.isAltBufferEnabled()) {
            System.arraycopy(this.terminal.altBuffer, startIndex + chars, this.terminal.altBuffer, startIndex, count);
            System.arraycopy(this.terminal.altColors, startIndex + chars, this.terminal.altColors, startIndex, count);
            System.arraycopy(this.terminal.altColorsBackground, startIndex + chars, this.terminal.altColorsBackground, startIndex, count);
            System.arraycopy(this.terminal.altStyles, startIndex + chars, this.terminal.altStyles, startIndex, count);
            Arrays.fill(this.terminal.altBuffer, endIndex, endIndex + chars, 32);
            Arrays.fill(this.terminal.altColors, endIndex, endIndex + chars, Terminal.DEFAULT_COLORS.Copy());
            Arrays.fill(this.terminal.altColorsBackground, endIndex, endIndex + chars, c.Copy());
            Arrays.fill(this.terminal.altStyles, endIndex, endIndex + chars, (byte)0);
        } else {
            System.arraycopy(this.terminal.buffer, startIndex + chars, this.terminal.buffer, startIndex, count);
            System.arraycopy(this.terminal.colors, startIndex + chars, this.terminal.colors, startIndex, count);
            System.arraycopy(this.terminal.colorsBackground, startIndex + chars, this.terminal.colorsBackground, startIndex, count);
            System.arraycopy(this.terminal.styles, startIndex + chars, this.terminal.styles, startIndex, count);
            Arrays.fill(this.terminal.buffer, endIndex, endIndex + chars, 32);
            Arrays.fill(this.terminal.colors, endIndex, endIndex + chars, Terminal.DEFAULT_COLORS.Copy());
            Arrays.fill(this.terminal.colorsBackground, endIndex, endIndex + chars, c.Copy());
            Arrays.fill(this.terminal.styles, endIndex, endIndex + chars, (byte)0);
        }
        this.terminal.renderers.forEach(model -> model.getDirtyMask().accumulateAndGet(1 << y, (left, right) -> left | right));
    }

    private void shiftRight(int chars) {
        int startIndex = (this.terminal.currentPrivateModeState.isAltBufferEnabled() ? this.terminal.y * 80 : (this.terminal.y + (this.terminal.lastRowToDisplayMax - 24)) * 80) + this.terminal.x;
        int count = 80 - this.terminal.x - chars;
        Terminal.ColorData c = switch (this.terminal.currentBackgroundColorMode) {
            case Terminal.ColorMode.SIXTEEN_COLOR -> this.terminal.sixteenColor;
            case Terminal.ColorMode.TWO_FIFTY_SIX_COLOR -> this.terminal.twoFiftySixColor;
            case Terminal.ColorMode.TRUE_COLOR -> this.terminal.backgroundColor;
            case Terminal.ColorMode.SIXTEEN_COLOR_BRIGHT -> this.terminal.sixteenColorBright;
            default -> Terminal.DEFAULT_BACKGROUND_COLOR;
        };
        if (this.terminal.currentPrivateModeState.isAltBufferEnabled()) {
            System.arraycopy(this.terminal.altBuffer, startIndex, this.terminal.altBuffer, startIndex + chars, count);
            System.arraycopy(this.terminal.altColors, startIndex, this.terminal.altColors, startIndex + chars, count);
            System.arraycopy(this.terminal.altColorsBackground, startIndex, this.terminal.altColorsBackground, startIndex + chars, count);
            System.arraycopy(this.terminal.altStyles, startIndex, this.terminal.altStyles, startIndex + chars, count);
            Arrays.fill(this.terminal.altBuffer, startIndex, startIndex + chars, 32);
            Arrays.fill(this.terminal.altColors, startIndex, startIndex + chars, Terminal.DEFAULT_COLORS.Copy());
            Arrays.fill(this.terminal.altColorsBackground, startIndex, startIndex + chars, c.Copy());
            Arrays.fill(this.terminal.altStyles, startIndex, startIndex + chars, (byte)0);
        } else {
            System.arraycopy(this.terminal.buffer, startIndex, this.terminal.buffer, startIndex + chars, count);
            System.arraycopy(this.terminal.colors, startIndex, this.terminal.colors, startIndex + chars, count);
            System.arraycopy(this.terminal.colorsBackground, startIndex, this.terminal.colorsBackground, startIndex + chars, count);
            System.arraycopy(this.terminal.styles, startIndex, this.terminal.styles, startIndex + chars, count);
            Arrays.fill(this.terminal.buffer, startIndex, startIndex + chars, 32);
            Arrays.fill(this.terminal.colors, startIndex, startIndex + chars, Terminal.DEFAULT_COLORS.Copy());
            Arrays.fill(this.terminal.colorsBackground, startIndex, startIndex + chars, c.Copy());
            Arrays.fill(this.terminal.styles, startIndex, startIndex + chars, (byte)0);
        }
        this.terminal.renderers.forEach(model -> model.getDirtyMask().accumulateAndGet(1 << this.terminal.y, (left, right) -> left | right));
    }
}

