/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm.terminal.escapes.csi;

import li.cil.oc2.common.vm.terminal.Terminal;
import li.cil.oc2.common.vm.terminal.escapes.csi.CSISequenceHandler;
import li.cil.oc2.common.vm.terminal.escapes.csi.CSIState;

public class SGR
extends CSISequenceHandler {
    public SGR(Terminal terminal) {
        super(terminal);
    }

    @Override
    public void execute(int[] args, int argCount, CSIState state) {
        for (int i = 0; i < argCount; ++i) {
            int v1 = args[i];
            if (v1 == 38 || v1 == 48) {
                int v2 = args[++i];
                if (v1 == 38) {
                    if (v2 == 5) {
                        this.terminal.currentForegroundColorMode = Terminal.ColorMode.TWO_FIFTY_SIX_COLOR;
                        this.terminal.twoFiftySixColor.R = args[++i];
                    } else if (v2 == 2) {
                        this.terminal.currentForegroundColorMode = Terminal.ColorMode.TRUE_COLOR;
                        this.terminal.foregroundColor = new Terminal.ColorData(args[++i], args[++i], args[++i], Terminal.ColorMode.TRUE_COLOR);
                    }
                } else if (v2 == 5) {
                    this.terminal.currentBackgroundColorMode = Terminal.ColorMode.TWO_FIFTY_SIX_COLOR;
                    this.terminal.twoFiftySixColor.G = args[++i];
                } else if (v2 == 2) {
                    this.terminal.currentBackgroundColorMode = Terminal.ColorMode.TRUE_COLOR;
                    this.terminal.backgroundColor = new Terminal.ColorData(args[++i], args[++i], args[++i], Terminal.ColorMode.TRUE_COLOR);
                }
                return;
            }
            SGR.selectStyle(this.terminal, v1);
        }
    }

    private static void selectStyle(Terminal terminal, int arg) {
        switch (arg) {
            case 0: {
                terminal.sixteenColor = Terminal.DEFAULT_COLORS.Copy();
                terminal.sixteenColorBright = Terminal.DEFAULT_BRIGHT_COLORS.Copy();
                terminal.style = 0;
                terminal.currentForegroundColorMode = Terminal.ColorMode.SIXTEEN_COLOR;
                terminal.currentBackgroundColorMode = Terminal.ColorMode.DEFAULT_BACKGROUND;
                terminal.twoFiftySixColor = Terminal.DEFAULT_256_COLORS.Copy();
                terminal.foregroundColor = Terminal.DEFAULT_TRUE_COLOR_FOREGROUND.Copy();
                terminal.backgroundColor = Terminal.DEFAULT_TRUE_COLOR_BACKGROUND.Copy();
                break;
            }
            case 1: {
                terminal.style = (byte)(terminal.style | 1);
                break;
            }
            case 2: {
                terminal.style = (byte)(terminal.style | 2);
                break;
            }
            case 3: {
                terminal.style = (byte)(terminal.style | 0x40);
                break;
            }
            case 4: {
                terminal.style = (byte)(terminal.style | 4);
                break;
            }
            case 5: {
                terminal.style = (byte)(terminal.style | 8);
                break;
            }
            case 7: {
                terminal.style = (byte)(terminal.style | 0x10);
                break;
            }
            case 8: {
                terminal.style = (byte)(terminal.style | 0x20);
                break;
            }
            case 22: {
                terminal.style = (byte)(terminal.style & 0xFFFFFFFC);
                break;
            }
            case 23: {
                terminal.style = (byte)(terminal.style & 0xFFFFFFBF);
                break;
            }
            case 24: {
                terminal.style = (byte)(terminal.style & 0xFFFFFFFB);
                break;
            }
            case 25: {
                terminal.style = (byte)(terminal.style & 0xFFFFFFF7);
                break;
            }
            case 27: {
                terminal.style = (byte)(terminal.style & 0xFFFFFFEF);
                break;
            }
            case 28: {
                terminal.style = (byte)(terminal.style & 0xFFFFFFDF);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                terminal.currentForegroundColorMode = Terminal.ColorMode.SIXTEEN_COLOR;
                terminal.sixteenColor.R = arg - 30;
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                terminal.currentBackgroundColorMode = Terminal.ColorMode.SIXTEEN_COLOR;
                terminal.sixteenColor.G = arg - 40;
                break;
            }
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                terminal.currentForegroundColorMode = Terminal.ColorMode.SIXTEEN_COLOR_BRIGHT;
                terminal.sixteenColorBright.R = arg - 90;
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                terminal.currentBackgroundColorMode = Terminal.ColorMode.SIXTEEN_COLOR_BRIGHT;
                terminal.sixteenColorBright.G = arg - 100;
            }
        }
    }
}

