/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm.terminal.fonts;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import li.cil.oc2.common.vm.terminal.fonts.Glyph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FontAtlas {
    private static final int PADDING = 2;
    private final ResourceLocation resources;
    private int atlasWidth;
    private int atlasHeight;
    public NativeImage atlasImage;
    private final DynamicTexture dynamicTexture;
    private final List<Glyph> glyphs;
    private int currentX = 0;
    private int currentY = 0;

    public FontAtlas(int initialWidth, int initialHeight, String fontAtlasName) {
        this.atlasWidth = initialWidth;
        this.atlasHeight = initialHeight;
        this.atlasImage = new NativeImage(this.atlasWidth, this.atlasHeight, false);
        this.dynamicTexture = new DynamicTexture(this.atlasImage);
        this.resources = ResourceLocation.fromNamespaceAndPath((String)"oc2r", (String)fontAtlasName);
        Minecraft.m_91087_().m_91097_().m_118495_(this.resources, (AbstractTexture)this.dynamicTexture);
        this.glyphs = new ArrayList<Glyph>();
        for (int x = 0; x < this.atlasWidth; ++x) {
            for (int y = 0; y < this.atlasHeight; ++y) {
                this.atlasImage.m_84988_(x, y, new Color(0, 0, 0, 0).getRGB());
            }
        }
        BufferedImage f = new BufferedImage(16, 32, 2);
        Graphics2D g = f.createGraphics();
        g.setColor(Color.WHITE);
        g.draw(new Rectangle(0, 0, 16, 32));
        g.dispose();
        Glyph square = new Glyph(f, 16, 32, 0);
        this.addGlyph(square);
        this.glyphs.add(square);
    }

    public void addGlyph(Glyph glyph) {
        if (this.currentX + glyph.image.getWidth() > this.atlasWidth) {
            this.currentX = 0;
            this.currentY += glyph.image.getHeight() + 2;
        }
        if (this.currentY + glyph.image.getHeight() > this.atlasHeight) {
            this.resizeAtlas();
        }
        for (int y = 0; y < glyph.image.getHeight(); ++y) {
            for (int x = 0; x < glyph.image.getWidth(); ++x) {
                int color = glyph.image.getRGB(x, y);
                this.atlasImage.m_84988_(this.currentX + x, this.currentY + y, color);
            }
        }
        float uStart = (float)this.currentX * (1.0f / (float)this.atlasWidth);
        float vStart = (float)this.currentY * (1.0f / (float)this.atlasHeight);
        float uEnd = (float)(this.currentX + glyph.image.getWidth() + 1) * (1.0f / (float)this.atlasWidth);
        float vEnd = (float)(this.currentY + glyph.image.getHeight() + 1) * (1.0f / (float)this.atlasHeight);
        glyph.setUV(uStart, vStart, uEnd, vEnd);
        this.glyphs.add(glyph);
        this.currentX += glyph.image.getWidth() + 2;
        this.updateTexture();
    }

    private void resizeAtlas() {
        int newWidth = this.atlasWidth * 2;
        int newHeight = this.atlasHeight * 2;
        NativeImage newAtlasImage = new NativeImage(newWidth, newHeight, false);
        for (int y = 0; y < this.atlasHeight; ++y) {
            for (int x = 0; x < this.atlasWidth; ++x) {
                int color = this.atlasImage.m_84985_(x, y);
                newAtlasImage.m_84988_(x, y, color);
            }
        }
        for (Glyph glyph : this.glyphs) {
            glyph.setUV(glyph.uStart / 2.0f, glyph.vStart / 2.0f, glyph.uEnd / 2.0f, glyph.vEnd / 2.0f);
        }
        this.atlasWidth = newWidth;
        this.atlasHeight = newHeight;
        this.atlasImage = newAtlasImage;
        this.dynamicTexture.m_117988_(this.atlasImage);
        this.updateTexture();
    }

    public ResourceLocation getTextureId() {
        return this.resources;
    }

    public void updateTexture() {
        this.dynamicTexture.m_117985_();
    }
}

