/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm.terminal.fonts;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import li.cil.oc2.common.Main;
import li.cil.oc2.common.vm.terminal.fonts.FontAtlas;
import li.cil.oc2.common.vm.terminal.fonts.Glyph;
import li.cil.oc2.common.vm.terminal.fonts.UnicodeFontRenderer;
import net.minecraft.resources.ResourceLocation;

public class FontHandling {
    public static final FontAtlas FontAtlas = new FontAtlas(1024, 1024, "font_atlas");
    public static final Font RegularFont = FontHandling.loadFont("/assets/oc2r/fonts/monocraft-r.ttf", 32.0f);
    public static final UnicodeFontRenderer regularFontRenderer = new UnicodeFontRenderer(RegularFont, false);
    public static final Font BoldFont = FontHandling.loadFont("/assets/oc2r/fonts/monocraft-b.ttf", 32.0f);
    public static final UnicodeFontRenderer boldFontRenderer = new UnicodeFontRenderer(BoldFont, false);
    public static final Font ItalicFont = FontHandling.loadFont("/assets/oc2r/fonts/monocraft-i.ttf", 32.0f);
    public static final UnicodeFontRenderer italicFontRenderer = new UnicodeFontRenderer(ItalicFont, true);
    public static final Font BoldItalicFont = FontHandling.loadFont("/assets/oc2r/fonts/monocraft-bi.ttf", 32.0f);
    public static final UnicodeFontRenderer boldItalicFontRenderer = new UnicodeFontRenderer(BoldItalicFont, true);

    public static Glyph getGlyph(int character, FontStyle style) {
        return switch (style) {
            default -> throw new IncompatibleClassChangeError();
            case FontStyle.REGULAR -> regularFontRenderer.getGlyph(character);
            case FontStyle.ITALIC -> italicFontRenderer.getGlyph(character);
            case FontStyle.BOLD -> boldFontRenderer.getGlyph(character);
            case FontStyle.BOLD_ITALIC -> boldItalicFontRenderer.getGlyph(character);
        };
    }

    public static ResourceLocation getAtlas() {
        return FontAtlas.getTextureId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Font loadFont(String path, float size) {
        try (InputStream is = Main.class.getResourceAsStream(path);){
            if (is == null) {
                Font font2 = new Font("Arial", 0, (int)size);
                return font2;
            }
            Font font = Font.createFont(0, is).deriveFont(size);
            return font;
        }
        catch (FontFormatException | IOException e) {
            return new Font("Arial", 0, (int)size);
        }
    }

    public static enum FontStyle {
        REGULAR,
        ITALIC,
        BOLD,
        BOLD_ITALIC;

    }
}

