/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.jcodec.codecs.h264;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import li.cil.oc2.jcodec.codecs.h264.H264Utils;
import li.cil.oc2.jcodec.codecs.h264.POCManager;
import li.cil.oc2.jcodec.codecs.h264.decode.DeblockerInput;
import li.cil.oc2.jcodec.codecs.h264.decode.FrameReader;
import li.cil.oc2.jcodec.codecs.h264.decode.SliceDecoder;
import li.cil.oc2.jcodec.codecs.h264.decode.SliceReader;
import li.cil.oc2.jcodec.codecs.h264.decode.deblock.DeblockingFilter;
import li.cil.oc2.jcodec.codecs.h264.io.model.Frame;
import li.cil.oc2.jcodec.codecs.h264.io.model.NALUnit;
import li.cil.oc2.jcodec.codecs.h264.io.model.NALUnitType;
import li.cil.oc2.jcodec.codecs.h264.io.model.PictureParameterSet;
import li.cil.oc2.jcodec.codecs.h264.io.model.RefPicMarking;
import li.cil.oc2.jcodec.codecs.h264.io.model.RefPicMarkingIDR;
import li.cil.oc2.jcodec.codecs.h264.io.model.SeqParameterSet;
import li.cil.oc2.jcodec.codecs.h264.io.model.SliceHeader;
import li.cil.oc2.jcodec.common.IntObjectMap;
import li.cil.oc2.jcodec.common.VideoDecoder;
import li.cil.oc2.jcodec.common.model.ColorSpace;
import li.cil.oc2.jcodec.common.tools.MathUtil;

public final class H264Decoder
extends VideoDecoder {
    private Frame[] sRefs;
    private IntObjectMap<Frame> lRefs;
    private final List<Frame> pictureBuffer = new ArrayList<Frame>();
    private final POCManager poc = new POCManager();
    private final FrameReader reader;
    private ExecutorService tp;
    private final boolean threaded;

    public H264Decoder() {
        boolean bl = this.threaded = Runtime.getRuntime().availableProcessors() > 1;
        if (this.threaded) {
            this.tp = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), r -> {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setName("h264 Decoder");
                t.setDaemon(true);
                return t;
            });
        }
        this.reader = new FrameReader();
    }

    @Override
    public Frame decodeFrame(ByteBuffer data, byte[][] buffer) {
        return this.decodeFrameFromNals(H264Utils.splitFrame(data), buffer);
    }

    public Frame decodeFrameFromNals(List<ByteBuffer> nalUnits, byte[][] buffer) {
        return new FrameDecoder(this).decodeFrame(nalUnits, buffer);
    }

    public static Frame createFrame(SeqParameterSet sps, byte[][] buffer, int frameNum, H264Utils.MvList2D mvs, Frame[][][] refsUsed, int POC) {
        int width = sps.picWidthInMbsMinus1 + 1 << 4;
        int height = SeqParameterSet.getPicHeightInMbs(sps) << 4;
        return new Frame(width, height, buffer, ColorSpace.YUV420, frameNum, mvs, refsUsed, POC);
    }

    static class FrameDecoder {
        private SeqParameterSet activeSps;
        private DeblockingFilter filter;
        private SliceHeader firstSliceHeader;
        private NALUnit firstNu;
        private final H264Decoder dec;
        private DeblockerInput di;

        public FrameDecoder(H264Decoder decoder) {
            this.dec = decoder;
        }

        public Frame decodeFrame(List<ByteBuffer> nalUnits, byte[][] buffer) {
            List<SliceReader> sliceReaders = this.dec.reader.readFrame(nalUnits);
            if (sliceReaders == null || sliceReaders.size() == 0) {
                return null;
            }
            Frame result = this.init(sliceReaders.get(0), buffer);
            if (this.dec.threaded && sliceReaders.size() > 1) {
                ArrayList futures = new ArrayList();
                for (SliceReader sliceReader : sliceReaders) {
                    SliceDecoder decoder = new SliceDecoder(this.activeSps, this.dec.sRefs, this.dec.lRefs, this.di, result);
                    futures.add(this.dec.tp.submit(() -> decoder.decodeFromReader(sliceReader)));
                }
                for (Future future : futures) {
                    this.waitForSure(future);
                }
            } else {
                for (SliceReader sliceReader : sliceReaders) {
                    new SliceDecoder(this.activeSps, this.dec.sRefs, this.dec.lRefs, this.di, result).decodeFromReader(sliceReader);
                }
            }
            this.filter.deblockFrame(result);
            this.updateReferences(result);
            return result;
        }

        private void waitForSure(Future<?> future) {
            try {
                future.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void updateReferences(Frame picture) {
            if (this.firstNu.nal_ref_idc != 0) {
                if (this.firstNu.type == NALUnitType.IDR_SLICE) {
                    this.performIDRMarking(this.firstSliceHeader.refPicMarkingIDR, picture);
                } else {
                    this.performMarking(this.firstSliceHeader.refPicMarkingNonIDR, picture);
                }
            }
        }

        private Frame init(SliceReader sliceReader, byte[][] buffer) {
            this.firstNu = sliceReader.getNALUnit();
            this.firstSliceHeader = sliceReader.getSliceHeader();
            this.activeSps = this.firstSliceHeader.sps;
            this.validateSupportedFeatures(this.firstSliceHeader.sps, this.firstSliceHeader.pps);
            if (this.dec.sRefs == null) {
                this.dec.sRefs = new Frame[1 << this.firstSliceHeader.sps.log2MaxFrameNumMinus4 + 4];
                this.dec.lRefs = new IntObjectMap();
            }
            this.di = new DeblockerInput(this.activeSps);
            Frame result = H264Decoder.createFrame(this.activeSps, buffer, this.firstSliceHeader.frameNum, this.di.mvs, this.di.refsUsed, this.dec.poc.calcPOC(this.firstSliceHeader, this.firstNu));
            this.filter = new DeblockingFilter(this.di);
            return result;
        }

        private void validateSupportedFeatures(SeqParameterSet sps, PictureParameterSet pps) {
            if (sps.mbAdaptiveFrameFieldFlag) {
                throw new RuntimeException("Unsupported h264 feature: MBAFF.");
            }
            if (sps.bitDepthLumaMinus8 != 0 || sps.bitDepthChromaMinus8 != 0) {
                throw new RuntimeException("Unsupported h264 feature: High bit depth.");
            }
            if (sps.chromaFormatIdc != ColorSpace.YUV420J) {
                throw new RuntimeException("Unsupported h264 feature: " + String.valueOf(sps.chromaFormatIdc) + " color.");
            }
            if (!sps.frameMbsOnlyFlag || sps.fieldPicFlag) {
                throw new RuntimeException("Unsupported h264 feature: interlace.");
            }
            if (pps.constrainedIntraPredFlag) {
                throw new RuntimeException("Unsupported h264 feature: constrained intra prediction.");
            }
            if (sps.qpprimeYZeroTransformBypassFlag) {
                throw new RuntimeException("Unsupported h264 feature: qprime zero transform bypass.");
            }
            if (sps.profileIdc != 66 && sps.profileIdc != 77 && sps.profileIdc != 100) {
                throw new RuntimeException("Unsupported h264 feature: " + sps.profileIdc + " profile.");
            }
        }

        public void performIDRMarking(RefPicMarkingIDR refPicMarkingIDR, Frame picture) {
            this.clearAll();
            this.dec.pictureBuffer.clear();
            Frame saved = this.saveRef(picture);
            if (refPicMarkingIDR.useForlongTerm()) {
                this.dec.lRefs.put(0, saved);
                saved.setShortTerm(false);
            } else {
                this.dec.sRefs[this.firstSliceHeader.frameNum] = saved;
            }
        }

        private Frame saveRef(Frame decoded) {
            Frame frame = this.dec.pictureBuffer.size() > 0 ? this.dec.pictureBuffer.remove(0) : Frame.createFrame(decoded);
            frame.copyFromFrame(decoded);
            return frame;
        }

        private void releaseRef(Frame picture) {
            if (picture != null) {
                this.dec.pictureBuffer.add(picture);
            }
        }

        public void clearAll() {
            int[] keys;
            for (int i = 0; i < this.dec.sRefs.length; ++i) {
                this.releaseRef(this.dec.sRefs[i]);
                this.dec.sRefs[i] = null;
            }
            for (int key : keys = this.dec.lRefs.keys()) {
                this.releaseRef(this.dec.lRefs.get(key));
            }
            this.dec.lRefs.clear();
        }

        public void performMarking(RefPicMarking refPicMarking, Frame picture) {
            Frame saved = this.saveRef(picture);
            if (refPicMarking != null) {
                RefPicMarking.Instruction[] instructions;
                block8: for (RefPicMarking.Instruction instr : instructions = refPicMarking.instructions()) {
                    switch (instr.type()) {
                        case REMOVE_SHORT: {
                            this.unrefShortTerm(instr.arg1());
                            continue block8;
                        }
                        case REMOVE_LONG: {
                            this.unrefLongTerm(instr.arg1());
                            continue block8;
                        }
                        case CONVERT_INTO_LONG: {
                            this.convert(instr.arg1(), instr.arg2());
                            continue block8;
                        }
                        case TRUNK_LONG: {
                            this.truncateLongTerm(instr.arg1() - 1);
                            continue block8;
                        }
                        case CLEAR: {
                            this.clearAll();
                            continue block8;
                        }
                        case MARK_LONG: {
                            this.saveLong(saved, instr.arg1());
                            saved = null;
                        }
                    }
                }
            }
            if (saved != null) {
                this.saveShort(saved);
            }
            int maxFrames = 1 << this.activeSps.log2MaxFrameNumMinus4 + 4;
            if (refPicMarking == null) {
                int maxShort = Math.max(1, this.activeSps.numRefFrames - this.dec.lRefs.size());
                int min = Integer.MAX_VALUE;
                int num = 0;
                int minFn = 0;
                for (int i = 0; i < this.dec.sRefs.length; ++i) {
                    if (this.dec.sRefs[i] == null) continue;
                    int fnWrap = this.unwrap(this.firstSliceHeader.frameNum, this.dec.sRefs[i].getFrameNo(), maxFrames);
                    if (fnWrap < min) {
                        min = fnWrap;
                        minFn = this.dec.sRefs[i].getFrameNo();
                    }
                    ++num;
                }
                if (num > maxShort) {
                    this.releaseRef(this.dec.sRefs[minFn]);
                    this.dec.sRefs[minFn] = null;
                }
            }
        }

        private int unwrap(int thisFrameNo, int refFrameNo, int maxFrames) {
            return refFrameNo > thisFrameNo ? refFrameNo - maxFrames : refFrameNo;
        }

        private void saveShort(Frame saved) {
            this.dec.sRefs[this.firstSliceHeader.frameNum] = saved;
        }

        private void saveLong(Frame saved, int longNo) {
            Frame prev = this.dec.lRefs.get(longNo);
            if (prev != null) {
                this.releaseRef(prev);
            }
            saved.setShortTerm(false);
            this.dec.lRefs.put(longNo, saved);
        }

        private void truncateLongTerm(int maxLongNo) {
            int[] keys;
            for (int key : keys = this.dec.lRefs.keys()) {
                if (key <= maxLongNo) continue;
                this.releaseRef(this.dec.lRefs.get(key));
                this.dec.lRefs.remove(key);
            }
        }

        private void convert(int shortNo, int longNo) {
            int ind = MathUtil.wrap(this.firstSliceHeader.frameNum - shortNo, 1 << this.firstSliceHeader.sps.log2MaxFrameNumMinus4 + 4);
            this.releaseRef(this.dec.lRefs.get(longNo));
            this.dec.lRefs.put(longNo, this.dec.sRefs[ind]);
            this.dec.sRefs[ind] = null;
            this.dec.lRefs.get(longNo).setShortTerm(false);
        }

        private void unrefLongTerm(int longNo) {
            this.releaseRef(this.dec.lRefs.get(longNo));
            this.dec.lRefs.remove(longNo);
        }

        private void unrefShortTerm(int shortNo) {
            int ind = MathUtil.wrap(this.firstSliceHeader.frameNum - shortNo, 1 << this.firstSliceHeader.sps.log2MaxFrameNumMinus4 + 4);
            this.releaseRef(this.dec.sRefs[ind]);
            this.dec.sRefs[ind] = null;
        }
    }
}

