/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.jcodec.codecs.h264;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import li.cil.oc2.jcodec.codecs.h264.H264Const;
import li.cil.oc2.jcodec.codecs.h264.H264Utils;
import li.cil.oc2.jcodec.codecs.h264.encode.CQPRateControl;
import li.cil.oc2.jcodec.codecs.h264.encode.EncodedMB;
import li.cil.oc2.jcodec.codecs.h264.encode.EncodingContext;
import li.cil.oc2.jcodec.codecs.h264.encode.IntraPredEstimator;
import li.cil.oc2.jcodec.codecs.h264.encode.MBDeblocker;
import li.cil.oc2.jcodec.codecs.h264.encode.MBEncoderHelper;
import li.cil.oc2.jcodec.codecs.h264.encode.MBWriterI16x16;
import li.cil.oc2.jcodec.codecs.h264.encode.MBWriterINxN;
import li.cil.oc2.jcodec.codecs.h264.encode.MBWriterP16x16;
import li.cil.oc2.jcodec.codecs.h264.encode.MotionEstimator;
import li.cil.oc2.jcodec.codecs.h264.encode.RateControl;
import li.cil.oc2.jcodec.codecs.h264.io.CAVLC;
import li.cil.oc2.jcodec.codecs.h264.io.model.MBType;
import li.cil.oc2.jcodec.codecs.h264.io.model.NALUnit;
import li.cil.oc2.jcodec.codecs.h264.io.model.NALUnitType;
import li.cil.oc2.jcodec.codecs.h264.io.model.PictureParameterSet;
import li.cil.oc2.jcodec.codecs.h264.io.model.RefPicMarkingIDR;
import li.cil.oc2.jcodec.codecs.h264.io.model.SeqParameterSet;
import li.cil.oc2.jcodec.codecs.h264.io.model.SliceHeader;
import li.cil.oc2.jcodec.codecs.h264.io.model.SliceType;
import li.cil.oc2.jcodec.codecs.h264.io.write.CAVLCWriter;
import li.cil.oc2.jcodec.codecs.h264.io.write.SliceHeaderWriter;
import li.cil.oc2.jcodec.common.VideoEncoder;
import li.cil.oc2.jcodec.common.io.BitWriter;
import li.cil.oc2.jcodec.common.model.ColorSpace;
import li.cil.oc2.jcodec.common.model.Picture;
import li.cil.oc2.jcodec.common.model.Size;
import li.cil.oc2.jcodec.common.tools.MathUtil;

public final class H264Encoder
extends VideoEncoder {
    private static final int KEY_INTERVAL_DEFAULT = 25;
    private static final int MOTION_SEARCH_RANGE_DEFAULT = 16;
    private final RateControl rc;
    private int frameNumber;
    private int keyInterval;
    private int motionSearchRange;
    private int maxPOC;
    private int maxFrameNumber;
    private SeqParameterSet sps;
    private PictureParameterSet pps;
    private MBWriterI16x16 mbEncoderI16x16;
    private MBWriterINxN mbEncoderINxN;
    private MBWriterP16x16 mbEncoderP16x16;
    private Picture ref;
    private Picture picOut;
    private EncodedMB[] topEncoded;
    private EncodingContext context;
    private boolean enableRdo;

    public static H264Encoder createH264Encoder() {
        return new H264Encoder(new CQPRateControl(24));
    }

    public H264Encoder(RateControl rc) {
        this.rc = rc;
        this.keyInterval = 25;
        this.motionSearchRange = 16;
    }

    public int getKeyInterval() {
        return this.keyInterval;
    }

    public void setKeyInterval(int keyInterval) {
        this.keyInterval = keyInterval;
    }

    public int getMotionSearchRange() {
        return this.motionSearchRange;
    }

    public void setMotionSearchRange(int motionSearchRange) {
        this.motionSearchRange = motionSearchRange;
    }

    public void setEnableRdo(boolean enableRdo) {
        this.enableRdo = enableRdo;
    }

    @Override
    public VideoEncoder.EncodedFrame encodeFrame(Picture pic, ByteBuffer _out) {
        if (pic.getColor() != ColorSpace.YUV420J) {
            throw new IllegalArgumentException("Input picture color is not supported: " + String.valueOf(pic.getColor()));
        }
        if (this.frameNumber >= this.keyInterval) {
            this.frameNumber = 0;
        }
        SliceType sliceType = this.frameNumber == 0 ? SliceType.I : SliceType.P;
        boolean idr = this.frameNumber == 0;
        ByteBuffer data = this.doEncodeFrame(pic, _out, idr, this.frameNumber++, sliceType);
        return new VideoEncoder.EncodedFrame(data, idr);
    }

    public ByteBuffer encodeIDRFrame(Picture pic, ByteBuffer _out) {
        this.frameNumber = 0;
        return this.doEncodeFrame(pic, _out, true, this.frameNumber, SliceType.I);
    }

    public ByteBuffer encodePFrame(Picture pic, ByteBuffer _out) {
        ++this.frameNumber;
        return this.doEncodeFrame(pic, _out, true, this.frameNumber, SliceType.P);
    }

    public ByteBuffer doEncodeFrame(Picture pic, ByteBuffer _out, boolean idr, int frameNumber, SliceType frameType) {
        ByteBuffer dup = _out.duplicate();
        int maxSize = Math.min(dup.remaining(), pic.getWidth() * pic.getHeight());
        maxSize -= maxSize >>> 6;
        int qp = this.rc.startPicture(pic.getSize(), maxSize, frameType);
        if (idr) {
            this.sps = this.initSPS(new Size(pic.getWidth(), pic.getHeight()));
            this.pps = this.initPPS();
            this.maxPOC = 1 << this.sps.log2MaxPicOrderCntLsbMinus4 + 4;
            this.maxFrameNumber = 1 << this.sps.log2MaxFrameNumMinus4 + 4;
        }
        if (idr) {
            dup.putInt(1);
            new NALUnit(NALUnitType.SPS, 3).write(dup);
            this.writeSPS(dup, this.sps);
            dup.putInt(1);
            new NALUnit(NALUnitType.PPS, 3).write(dup);
            this.writePPS(dup, this.pps);
        }
        int mbWidth = this.sps.picWidthInMbsMinus1 + 1;
        int mbHeight = this.sps.picHeightInMapUnitsMinus1 + 1;
        this.context = new EncodingContext(mbWidth, mbHeight);
        this.picOut = Picture.create(mbWidth << 4, mbHeight << 4, ColorSpace.YUV420J);
        this.topEncoded = new EncodedMB[mbWidth];
        this.encodeSlice(this.sps, this.pps, pic, dup, idr, frameNumber, frameType, qp);
        this.putLastMBLine();
        this.ref = this.picOut;
        dup.flip();
        return dup;
    }

    private void writePPS(ByteBuffer dup, PictureParameterSet pps) {
        ByteBuffer tmp = ByteBuffer.allocate(1024);
        pps.write(tmp);
        tmp.flip();
        H264Utils.escapeNAL(tmp, dup);
    }

    private void writeSPS(ByteBuffer dup, SeqParameterSet sps) {
        ByteBuffer tmp = ByteBuffer.allocate(1024);
        sps.write(tmp);
        tmp.flip();
        H264Utils.escapeNAL(tmp, dup);
    }

    public PictureParameterSet initPPS() {
        PictureParameterSet pps = new PictureParameterSet();
        pps.picInitQpMinus26 = 0;
        return pps;
    }

    public SeqParameterSet initSPS(Size sz) {
        SeqParameterSet sps = new SeqParameterSet();
        sps.picWidthInMbsMinus1 = (sz.width() + 15 >> 4) - 1;
        sps.picHeightInMapUnitsMinus1 = (sz.height() + 15 >> 4) - 1;
        sps.chromaFormatIdc = ColorSpace.YUV420J;
        sps.profileIdc = 66;
        sps.levelIdc = 40;
        sps.numRefFrames = 1;
        sps.frameMbsOnlyFlag = true;
        sps.log2MaxFrameNumMinus4 = Math.max(0, MathUtil.log2(this.keyInterval) - 3);
        int codedWidth = sps.picWidthInMbsMinus1 + 1 << 4;
        int codedHeight = sps.picHeightInMapUnitsMinus1 + 1 << 4;
        sps.frameCroppingFlag = codedWidth != sz.width() || codedHeight != sz.height();
        sps.frameCropRightOffset = codedWidth - sz.width() + 1 >> 1;
        sps.frameCropBottomOffset = codedHeight - sz.height() + 1 >> 1;
        return sps;
    }

    private void encodeSlice(SeqParameterSet sps, PictureParameterSet pps, Picture pic, ByteBuffer dup, boolean idr, int frameNum, SliceType sliceType, int sliceQp) {
        if (idr && sliceType != SliceType.I) {
            idr = false;
        }
        this.context.cavlc = new CAVLC[]{new CAVLC(sps, 2, 2), new CAVLC(sps, 1, 1), new CAVLC(sps, 1, 1)};
        this.mbEncoderI16x16 = new MBWriterI16x16();
        this.mbEncoderINxN = new MBWriterINxN();
        this.mbEncoderP16x16 = new MBWriterP16x16(sps, this.ref);
        dup.putInt(1);
        new NALUnit(idr ? NALUnitType.IDR_SLICE : NALUnitType.NON_IDR_SLICE, 3).write(dup);
        SliceHeader sh = new SliceHeader();
        sh.sliceType = sliceType;
        if (idr) {
            sh.refPicMarkingIDR = new RefPicMarkingIDR(false, false);
        }
        sh.pps = pps;
        sh.sps = sps;
        sh.picOrderCntLsb = (frameNum << 1) % this.maxPOC;
        sh.frameNum = frameNum % this.maxFrameNumber;
        sh.sliceQpDelta = sliceQp - (pps.picInitQpMinus26 + 26);
        ByteBuffer buf = ByteBuffer.allocate(pic.getWidth() * pic.getHeight());
        BitWriter sliceData = new BitWriter(buf);
        SliceHeaderWriter.write(sh, idr, 2, sliceData);
        MotionEstimator estimator = new MotionEstimator(this.ref, sps, this.motionSearchRange);
        this.context.prevQp = sliceQp;
        int mbWidth = sps.picWidthInMbsMinus1 + 1;
        int mbHeight = sps.picHeightInMapUnitsMinus1 + 1;
        int oldQp = sliceQp;
        int mbAddr = 0;
        for (int mbY = 0; mbY < mbHeight; ++mbY) {
            int mbX = 0;
            while (mbX < mbWidth) {
                EncodingContext fork;
                BitWriter candidate;
                if (sliceType == SliceType.P) {
                    CAVLCWriter.writeUE(sliceData, 0);
                }
                int qpDelta = this.rc.initialQpDelta(pic, mbX, mbY);
                int mbQp = oldQp + qpDelta;
                int[] mv = null;
                if (this.ref != null) {
                    mv = estimator.mvEstimate(pic, mbX, mbY);
                }
                NonRdVector params = new NonRdVector(mv, IntraPredEstimator.getLumaMode(pic, this.context, mbX, mbY), IntraPredEstimator.getLumaPred4x4(pic, this.context, mbX, mbY, mbQp), IntraPredEstimator.getChromaMode(pic, this.context, mbX, mbY));
                EncodedMB outMB = new EncodedMB();
                outMB.setPos(mbX, mbY);
                do {
                    candidate = sliceData.fork();
                    fork = this.context.fork();
                    this.rdMacroblock(fork, outMB, sliceType, pic, mbX, mbY, candidate, sliceQp, mbQp, params);
                    qpDelta = this.rc.accept(candidate.position() - sliceData.position());
                    if (qpDelta == 0) continue;
                    mbQp += qpDelta;
                } while (qpDelta != 0);
                estimator.mvSave(mbX, new int[]{outMB.mx[0], outMB.my[0], outMB.mr[0]});
                sliceData = candidate;
                this.context = fork;
                oldQp = mbQp;
                this.context.update(outMB);
                new MBDeblocker().deblockMBP(outMB, mbX > 0 ? this.topEncoded[mbX - 1] : null, mbY > 0 ? this.topEncoded[mbX] : null);
                this.addToReference(outMB, mbX, mbY);
                ++mbX;
                ++mbAddr;
            }
        }
        sliceData.write1Bit(1);
        sliceData.flush();
        buf = sliceData.getBuffer();
        buf.flip();
        H264Utils.escapeNAL(buf, dup);
    }

    private void calcMse(Picture pic, EncodedMB out, int mbX, int mbY, long[] out_se) {
        byte[] patch = new byte[256];
        for (int p = 0; p < 3; ++p) {
            byte[] outPix = out.getPixels().getData()[p];
            int luma = p == 0 ? 1 : 0;
            MBEncoderHelper.take(pic.getPlaneData(p), pic.getPlaneWidth(p), pic.getPlaneHeight(p), mbX << 3 + luma, mbY << 3 + luma, patch, 8 << luma, 8 << luma);
            for (int i = 0; i < 64 << luma * 2; ++i) {
                int q = outPix[i] - patch[i];
                int n = p;
                out_se[n] = out_se[n] + (long)(q * q);
            }
        }
    }

    private void rdMacroblock(EncodingContext ctx, EncodedMB outMB, SliceType sliceType, Picture pic, int mbX, int mbY, BitWriter candidate, int sliceQp, int mbQp, NonRdVector params) {
        if (!this.enableRdo) {
            RdVector vector = sliceType == SliceType.P ? new RdVector(MBType.P_16x16, mbQp) : new RdVector(MBType.I_16x16, mbQp);
            this.encodeCand(ctx, outMB, sliceType, pic, mbX, mbY, candidate, params, vector);
            return;
        }
        LinkedList<RdVector> cands = new LinkedList<RdVector>();
        cands.add(new RdVector(MBType.I_16x16, mbQp));
        cands.add(new RdVector(MBType.I_NxN, mbQp));
        if (sliceType == SliceType.P) {
            cands.add(new RdVector(MBType.P_16x16, mbQp));
        }
        long bestRd = Long.MAX_VALUE;
        RdVector bestVector = null;
        for (RdVector rdVector : cands) {
            BitWriter candBits;
            EncodingContext candCtx = ctx.fork();
            long rdCost = this.tryVector(candCtx, sliceType, pic, mbX, mbY, candBits = candidate.fork(), sliceQp, params, rdVector);
            if (rdCost >= bestRd) continue;
            bestRd = rdCost;
            bestVector = rdVector;
        }
        this.encodeCand(ctx, outMB, sliceType, pic, mbX, mbY, candidate, params, bestVector);
    }

    private long tryVector(EncodingContext ctx, SliceType sliceType, Picture pic, int mbX, int mbY, BitWriter candidate, int sliceQp, NonRdVector params, RdVector vector) {
        int start = candidate.position();
        EncodedMB outMB = new EncodedMB();
        outMB.setPos(mbX, mbY);
        this.encodeCand(ctx, outMB, sliceType, pic, mbX, mbY, candidate, params, vector);
        long[] se = new long[3];
        this.calcMse(pic, outMB, mbX, mbY, se);
        long mse = (se[0] + se[1] + se[2]) / 384L;
        int bits = candidate.position() - start;
        return this.rdCost(mse, bits, H264Const.lambda[sliceQp]);
    }

    private long rdCost(long mse, int bits, int lambda) {
        return mse + (long)(lambda * bits >> 8);
    }

    private void encodeCand(EncodingContext ctx, EncodedMB outMB, SliceType sliceType, Picture pic, int mbX, int mbY, BitWriter candidate, NonRdVector params, RdVector vector) {
        if (vector.mbType == MBType.I_16x16) {
            BitWriter tmp = new BitWriter(ByteBuffer.allocate(1024));
            boolean cbpLuma = this.mbEncoderI16x16.encodeMacroblock(ctx, pic, mbX, mbY, tmp, outMB, vector.qp, params);
            int cbpChroma = this.mbEncoderI16x16.getCbpChroma();
            int i16x16TypeOffset = (cbpLuma ? 12 : 0) + cbpChroma * 4 + params.lumaPred16x16;
            int mbTypeOffset = sliceType == SliceType.P ? 5 : 0;
            CAVLCWriter.writeUE(candidate, mbTypeOffset + vector.mbType.code() + i16x16TypeOffset);
            candidate.writeOther(tmp);
        } else if (vector.mbType == MBType.P_16x16) {
            CAVLCWriter.writeUE(candidate, vector.mbType.code());
            this.mbEncoderP16x16.encodeMacroblock(ctx, pic, mbX, mbY, candidate, outMB, vector.qp, params);
        } else if (vector.mbType == MBType.I_NxN) {
            CAVLCWriter.writeUE(candidate, sliceType == SliceType.P ? 5 : 0);
            this.mbEncoderINxN.encodeMacroblock(ctx, pic, mbX, mbY, candidate, outMB, vector.qp, params);
        } else {
            throw new RuntimeException("Macroblock of type " + String.valueOf(vector.mbType) + " is not supported.");
        }
    }

    private void addToReference(EncodedMB outMB, int mbX, int mbY) {
        if (mbY > 0) {
            MBEncoderHelper.putBlkPic(this.picOut, this.topEncoded[mbX].getPixels(), mbX << 4, mbY - 1 << 4);
        }
        this.topEncoded[mbX] = outMB;
    }

    private void putLastMBLine() {
        int mbWidth = this.sps.picWidthInMbsMinus1 + 1;
        int mbHeight = this.sps.picHeightInMapUnitsMinus1 + 1;
        for (int mbX = 0; mbX < mbWidth; ++mbX) {
            MBEncoderHelper.putBlkPic(this.picOut, this.topEncoded[mbX].getPixels(), mbX << 4, mbHeight - 1 << 4);
        }
    }

    @Override
    public ColorSpace[] getSupportedColorSpaces() {
        return new ColorSpace[]{ColorSpace.YUV420J};
    }

    @Override
    public int estimateBufferSize(Picture frame) {
        return Math.max(65536, frame.getWidth() * frame.getHeight());
    }

    public static class NonRdVector {
        public final int[] mv;
        public final int lumaPred16x16;
        public final int[] lumaPred4x4;
        public final int chrPred;

        public NonRdVector(int[] mv, int lumaPred16x16, int[] lumaPred4x4, int chrPred) {
            this.mv = mv;
            this.lumaPred16x16 = lumaPred16x16;
            this.lumaPred4x4 = lumaPred4x4;
            this.chrPred = chrPred;
        }
    }

    public static class RdVector {
        public final MBType mbType;
        public final int qp;

        public RdVector(MBType mbType, int qp) {
            this.mbType = mbType;
            this.qp = qp;
        }
    }
}

