/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.jcodec.codecs.h264;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public final class H264Utils {
    public static ByteBuffer nextNALUnit(ByteBuffer buf) {
        H264Utils.skipToNALUnit(buf);
        if (buf.hasArray()) {
            return H264Utils.gotoNALUnitWithArray(buf);
        }
        return H264Utils.gotoNALUnit(buf);
    }

    public static void skipToNALUnit(ByteBuffer buf) {
        if (!buf.hasRemaining()) {
            return;
        }
        int val = -1;
        while (buf.hasRemaining()) {
            val <<= 8;
            if (((val |= buf.get() & 0xFF) & 0xFFFFFF) != 1) continue;
            buf.position(buf.position());
            break;
        }
    }

    public static ByteBuffer gotoNALUnit(ByteBuffer buf) {
        if (!buf.hasRemaining()) {
            return null;
        }
        int from = buf.position();
        ByteBuffer result = buf.slice();
        result.order(ByteOrder.BIG_ENDIAN);
        int val = -1;
        while (buf.hasRemaining()) {
            val <<= 8;
            if (((val |= buf.get() & 0xFF) & 0xFFFFFF) != 1) continue;
            buf.position(buf.position() - (val == 1 ? 4 : 3));
            result.limit(buf.position() - from);
            break;
        }
        return result;
    }

    public static ByteBuffer gotoNALUnitWithArray(ByteBuffer buf) {
        int pos;
        if (!buf.hasRemaining()) {
            return null;
        }
        int from = buf.position();
        ByteBuffer result = buf.slice();
        result.order(ByteOrder.BIG_ENDIAN);
        byte[] arr = buf.array();
        int posFrom = pos = from + buf.arrayOffset();
        int lim = buf.limit() + buf.arrayOffset();
        while (pos < lim) {
            byte b = arr[pos];
            if ((b & 0xFE) == 0) {
                while (b == 0 && ++pos < lim) {
                    b = arr[pos];
                }
                if (b == 1 && pos - posFrom >= 2 && arr[pos - 1] == 0 && arr[pos - 2] == 0) {
                    int lenSize = pos - posFrom >= 3 && arr[pos - 3] == 0 ? 4 : 3;
                    buf.position(pos + 1 - buf.arrayOffset() - lenSize);
                    result.limit(buf.position() - from);
                    return result;
                }
            }
            pos += 3;
        }
        buf.position(buf.limit());
        return result;
    }

    public static void unescapeNAL(ByteBuffer _buf) {
        if (_buf.remaining() < 2) {
            return;
        }
        ByteBuffer _in = _buf.duplicate();
        ByteBuffer out = _buf.duplicate();
        byte p1 = _in.get();
        out.put(p1);
        byte p2 = _in.get();
        out.put(p2);
        while (_in.hasRemaining()) {
            byte b = _in.get();
            if (p1 != 0 || p2 != 0 || b != 3) {
                out.put(b);
            }
            p1 = p2;
            p2 = b;
        }
        _buf.limit(out.position());
    }

    public static void escapeNAL(ByteBuffer src, ByteBuffer dst) {
        int p1 = src.get();
        int p2 = src.get();
        dst.put((byte)p1);
        dst.put((byte)p2);
        while (src.hasRemaining()) {
            int b = src.get();
            if (p1 == 0 && p2 == 0 && (b & 0xFF) <= 3) {
                dst.put((byte)3);
                p2 = 3;
            }
            dst.put((byte)b);
            p1 = p2;
            p2 = b;
        }
    }

    public static List<ByteBuffer> splitFrame(ByteBuffer frame) {
        ByteBuffer segment;
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        while ((segment = H264Utils.nextNALUnit(frame)) != null) {
            result.add(segment);
        }
        return result;
    }

    public static int golomb2Signed(int val) {
        int sign = ((val & 1) << 1) - 1;
        val = ((val >> 1) + (val & 1)) * sign;
        return val;
    }

    public static class MvList2D {
        private final int[] list;
        private final int stride;
        private final int width;
        private final int height;
        private static final int NA = Mv.packMv(0, 0, -1);

        public MvList2D(int width, int height) {
            this.list = new int[(width << 1) * height];
            this.stride = width << 1;
            this.width = width;
            this.height = height;
            this.clear();
        }

        public void clear() {
            for (int i = 0; i < this.list.length; i += 2) {
                int n = NA;
                this.list[i + 1] = n;
                this.list[i] = n;
            }
        }

        public int getMv(int offX, int offY, int forward) {
            return this.list[(offX << 1) + this.stride * offY + forward];
        }

        public void setMv(int offX, int offY, int forward, int mv) {
            this.list[(offX << 1) + this.stride * offY + forward] = mv;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }
    }

    public static class MvList {
        private final int[] list;
        private static final int NA = Mv.packMv(0, 0, -1);

        public MvList(int size) {
            this.list = new int[size << 1];
            this.clear();
        }

        public void clear() {
            for (int i = 0; i < this.list.length; i += 2) {
                int n = NA;
                this.list[i + 1] = n;
                this.list[i] = n;
            }
        }

        public int mv0X(int off) {
            return Mv.mvX(this.list[off << 1]);
        }

        public int mv0Y(int off) {
            return Mv.mvY(this.list[off << 1]);
        }

        public int mv0R(int off) {
            return Mv.mvRef(this.list[off << 1]);
        }

        public int mv1X(int off) {
            return Mv.mvX(this.list[(off << 1) + 1]);
        }

        public int mv1Y(int off) {
            return Mv.mvY(this.list[(off << 1) + 1]);
        }

        public int mv1R(int off) {
            return Mv.mvRef(this.list[(off << 1) + 1]);
        }

        public int getMv(int off, int forward) {
            return this.list[(off << 1) + forward];
        }

        public void setMv(int off, int forward, int mv) {
            this.list[(off << 1) + forward] = mv;
        }

        public void setPair(int off, int mv0, int mv1) {
            this.list[off << 1] = mv0;
            this.list[(off << 1) + 1] = mv1;
        }

        public void copyPair(int off, MvList other, int otherOff) {
            this.list[off << 1] = other.list[otherOff << 1];
            this.list[(off << 1) + 1] = other.list[(otherOff << 1) + 1];
        }
    }

    public static final class Mv {
        public static int mvX(int mv) {
            return mv << 18 >> 18;
        }

        public static int mvY(int mv) {
            return mv << 6 >> 20;
        }

        public static int mvRef(int mv) {
            return mv >> 26;
        }

        public static int packMv(int mvx, int mvy, int r) {
            return (r & 0x3F) << 26 | (mvy & 0xFFF) << 14 | mvx & 0x3FFF;
        }

        public static int mvC(int mv, int comp) {
            return comp == 0 ? Mv.mvX(mv) : Mv.mvY(mv);
        }
    }
}

