/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.jcodec.codecs.h264.decode;

import li.cil.oc2.jcodec.codecs.h264.H264Const;
import li.cil.oc2.jcodec.codecs.h264.decode.DeblockerInput;
import li.cil.oc2.jcodec.codecs.h264.decode.DecoderState;
import li.cil.oc2.jcodec.codecs.h264.decode.Intra4x4PredictionBuilder;
import li.cil.oc2.jcodec.codecs.h264.decode.Intra8x8PredictionBuilder;
import li.cil.oc2.jcodec.codecs.h264.decode.MBlock;
import li.cil.oc2.jcodec.codecs.h264.decode.MBlockDecoderBase;
import li.cil.oc2.jcodec.codecs.h264.decode.MBlockDecoderUtils;
import li.cil.oc2.jcodec.codecs.h264.decode.aso.Mapper;
import li.cil.oc2.jcodec.codecs.h264.io.model.SliceHeader;
import li.cil.oc2.jcodec.common.model.Picture;

public final class MBlockDecoderIntraNxN
extends MBlockDecoderBase {
    private final Mapper mapper;
    private final Intra8x8PredictionBuilder prediction8x8Builder;

    public MBlockDecoderIntraNxN(Mapper mapper, SliceHeader sh, DeblockerInput di, int poc, DecoderState decoderState) {
        super(sh, di, poc, decoderState);
        this.mapper = mapper;
        this.prediction8x8Builder = new Intra8x8PredictionBuilder();
    }

    public void decode(MBlock mBlock, Picture mb) {
        int mbX = this.mapper.getMbX(mBlock.mbIdx);
        int mbY = this.mapper.getMbY(mBlock.mbIdx);
        int mbAddr = this.mapper.getAddress(mBlock.mbIdx);
        boolean leftAvailable = this.mapper.leftAvailable(mBlock.mbIdx);
        boolean topAvailable = this.mapper.topAvailable(mBlock.mbIdx);
        boolean topLeftAvailable = this.mapper.topLeftAvailable(mBlock.mbIdx);
        boolean topRightAvailable = this.mapper.topRightAvailable(mBlock.mbIdx);
        if (mBlock.cbpLuma() > 0 || mBlock.cbpChroma() > 0) {
            this.s.qp = (this.s.qp + mBlock.mbQPDelta + 52) % 52;
        }
        this.di.mbQps[0][mbAddr] = this.s.qp;
        this.residualLuma(mBlock);
        if (!mBlock.transform8x8Used) {
            for (int bInd = 0; bInd < 16; ++bInd) {
                int dInd = H264Const.BLK_DISP_MAP[bInd];
                int blkX = (dInd & 3) << 2;
                int blkY = dInd & 0xFFFFFFFC;
                boolean trAvailable = (bInd == 0 || bInd == 1 || bInd == 4) && topAvailable || bInd == 5 && topRightAvailable || bInd == 2 || bInd == 6 || bInd == 8 || bInd == 9 || bInd == 10 || bInd == 12 || bInd == 14;
                Intra4x4PredictionBuilder.predictWithMode(mBlock.lumaModes[bInd], mBlock.ac[0][bInd], blkX != 0 || leftAvailable, blkY != 0 || topAvailable, trAvailable, this.s.leftRow[0], this.s.topLine[0], this.s.topLeft[0], mbX << 4, blkX, blkY, mb.getPlaneData(0));
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                boolean trAvailable;
                int blkX = (i & 1) << 1;
                int blkY = i & 2;
                boolean bl = trAvailable = i == 0 && topAvailable || i == 1 && topRightAvailable || i == 2;
                boolean tlAvailable = i == 0 ? topLeftAvailable : (i == 1 ? topAvailable : i != 2 || leftAvailable);
                this.prediction8x8Builder.predictWithMode(mBlock.lumaModes[i], mBlock.ac[0][i], blkX != 0 || leftAvailable, blkY != 0 || topAvailable, tlAvailable, trAvailable, this.s.leftRow[0], this.s.topLine[0], this.s.topLeft[0], mbX << 4, blkX << 2, blkY << 2, mb.getPlaneData(0));
            }
        }
        this.decodeChroma(mBlock, mbX, mbY, leftAvailable, topAvailable, mb, this.s.qp);
        this.di.mbTypes[mbAddr] = mBlock.curMbType;
        this.di.tr8x8Used[mbAddr] = mBlock.transform8x8Used;
        MBlockDecoderUtils.collectChromaPredictors(this.s, mb, mbX);
        MBlockDecoderUtils.saveMvsIntra(this.di, mbX, mbY);
        MBlockDecoderUtils.saveVectIntra(this.s, this.mapper.getMbX(mBlock.mbIdx));
    }
}

