/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.jcodec.codecs.h264.decode;

import java.util.Arrays;
import java.util.Comparator;
import li.cil.oc2.jcodec.codecs.h264.H264Const;
import li.cil.oc2.jcodec.codecs.h264.io.model.Frame;
import li.cil.oc2.jcodec.codecs.h264.io.model.SliceHeader;
import li.cil.oc2.jcodec.codecs.h264.io.model.SliceType;
import li.cil.oc2.jcodec.common.IntObjectMap;
import li.cil.oc2.jcodec.common.model.Picture;
import li.cil.oc2.jcodec.common.tools.MathUtil;

public final class RefListManager {
    private final SliceHeader sh;
    private final int[] numRef;
    private final Frame[] sRefs;
    private final IntObjectMap<Frame> lRefs;
    private final Frame frameOut;

    public RefListManager(SliceHeader sh, Frame[] sRefs, IntObjectMap<Frame> lRefs, Frame frameOut) {
        this.sh = sh;
        this.sRefs = sRefs;
        this.lRefs = lRefs;
        this.numRef = sh.numRefIdxActiveOverrideFlag ? new int[]{sh.numRefIdxActiveMinus1[0] + 1, sh.numRefIdxActiveMinus1[1] + 1} : new int[]{sh.pps.numRefIdxActiveMinus1[0] + 1, sh.pps.numRefIdxActiveMinus1[1] + 1};
        this.frameOut = frameOut;
    }

    public Frame[][] getRefList() {
        Frame[][] refList = null;
        if (this.sh.sliceType == SliceType.P) {
            refList = new Frame[][]{this.buildRefListP(), null};
        } else if (this.sh.sliceType == SliceType.B) {
            refList = this.buildRefListB();
        }
        return refList;
    }

    private Frame[] buildRefListP() {
        int frame_num = this.sh.frameNum;
        int maxFrames = 1 << this.sh.sps.log2MaxFrameNumMinus4 + 4;
        Picture[] result = new Frame[this.numRef[0]];
        int refs = 0;
        for (int i = frame_num - 1; i >= frame_num - maxFrames && refs < this.numRef[0]; --i) {
            int fn;
            int n = fn = i < 0 ? i + maxFrames : i;
            if (this.sRefs[fn] == null) continue;
            result[refs] = this.sRefs[fn] == H264Const.NO_PIC ? null : this.sRefs[fn];
            ++refs;
        }
        int[] keys = this.lRefs.keys();
        Arrays.sort(keys);
        for (int i = 0; i < keys.length && refs < this.numRef[0]; ++i) {
            result[refs++] = this.lRefs.get(keys[i]);
        }
        this.reorder(result, 0);
        return result;
    }

    private Frame[][] buildRefListB() {
        Object[] l1;
        Object[] l0 = this.buildList(Frame.POCDesc, Frame.POCAsc);
        if (Arrays.equals(l0, l1 = this.buildList(Frame.POCAsc, Frame.POCDesc)) && this.count((Frame[])l1) > 1) {
            Object frame = l1[1];
            l1[1] = l1[0];
            l1[0] = frame;
        }
        Frame[][] result = new Frame[][]{(Frame[])Arrays.copyOf(l0, this.numRef[0]), (Frame[])Arrays.copyOf(l1, this.numRef[1])};
        this.reorder(result[0], 0);
        this.reorder(result[1], 1);
        return result;
    }

    private Frame[] buildList(Comparator<Frame> cmpFwd, Comparator<Frame> cmpInv) {
        Frame[] refs = new Frame[this.sRefs.length + this.lRefs.size()];
        Frame[] fwd = this.copySort(cmpFwd, this.frameOut);
        Frame[] inv = this.copySort(cmpInv, this.frameOut);
        int nFwd = this.count(fwd);
        int nInv = this.count(inv);
        int ref = 0;
        int i = 0;
        while (i < nFwd) {
            refs[ref] = fwd[i];
            ++i;
            ++ref;
        }
        i = 0;
        while (i < nInv) {
            refs[ref] = inv[i];
            ++i;
            ++ref;
        }
        int[] keys = this.lRefs.keys();
        Arrays.sort(keys);
        int i2 = 0;
        while (i2 < keys.length) {
            refs[ref] = this.lRefs.get(keys[i2]);
            ++i2;
            ++ref;
        }
        return refs;
    }

    private int count(Frame[] arr) {
        for (int nn = 0; nn < arr.length; ++nn) {
            if (arr[nn] != null) continue;
            return nn;
        }
        return arr.length;
    }

    private Frame[] copySort(Comparator<Frame> fwd, Frame dummy) {
        Frame[] copyOf = Arrays.copyOf(this.sRefs, this.sRefs.length);
        for (int i = 0; i < copyOf.length; ++i) {
            if (fwd.compare(dummy, copyOf[i]) <= 0) continue;
            copyOf[i] = null;
        }
        Arrays.sort(copyOf, fwd);
        return copyOf;
    }

    private void reorder(Picture[] result, int list) {
        if (this.sh.refPicReordering[list] == null) {
            return;
        }
        int predict = this.sh.frameNum;
        int maxFrames = 1 << this.sh.sps.log2MaxFrameNumMinus4 + 4;
        for (int ind = 0; ind < this.sh.refPicReordering[list][0].length; ++ind) {
            int i;
            int refType = this.sh.refPicReordering[list][0][ind];
            int refIdx = this.sh.refPicReordering[list][1][ind];
            int count = this.numRef[list] - 1 - ind;
            if (count > 0) {
                System.arraycopy(result, ind, result, ind + 1, count);
            }
            if (refType == 2) {
                result[ind] = this.lRefs.get(refIdx);
            } else {
                predict = refType == 0 ? MathUtil.wrap(predict - refIdx - 1, maxFrames) : MathUtil.wrap(predict + refIdx + 1, maxFrames);
                result[ind] = this.sRefs[predict];
            }
            int j = i = ind + 1;
            while (i < this.numRef[list] && result[i] != null) {
                if (result[i] != this.sRefs[predict]) {
                    result[j++] = result[i];
                }
                ++i;
            }
        }
    }
}

