/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.jcodec.codecs.h264.encode;

import li.cil.oc2.jcodec.codecs.h264.encode.EncodedMB;
import li.cil.oc2.jcodec.codecs.h264.io.CAVLC;
import li.cil.oc2.jcodec.codecs.h264.io.model.MBType;

public final class EncodingContext {
    public CAVLC[] cavlc;
    public final byte[][] leftRow;
    public final byte[][] topLine;
    public final byte[] topLeft;
    public final int[] mvTopX;
    public final int[] mvTopY;
    public final int[] mvTopR;
    public final int[] mvLeftX;
    public final int[] mvLeftY;
    public final int[] mvLeftR;
    public int mvTopLeftX;
    public int mvTopLeftY;
    public int mvTopLeftR;
    public final int mbHeight;
    public final int mbWidth;
    public int prevQp;
    public final int[] i4x4PredTop;
    public final int[] i4x4PredLeft;
    public MBType leftMBType;
    public final MBType[] topMBType;

    public EncodingContext(int mbWidth, int mbHeight) {
        this.mbWidth = mbWidth;
        this.mbHeight = mbHeight;
        this.leftRow = new byte[][]{new byte[16], new byte[8], new byte[8]};
        this.topLine = new byte[][]{new byte[mbWidth << 4], new byte[mbWidth << 3], new byte[mbWidth << 3]};
        this.topLeft = new byte[4];
        this.mvTopX = new int[mbWidth << 2];
        this.mvTopY = new int[mbWidth << 2];
        this.mvTopR = new int[mbWidth << 2];
        this.mvLeftX = new int[4];
        this.mvLeftY = new int[4];
        this.mvLeftR = new int[4];
        this.i4x4PredTop = new int[mbWidth << 2];
        this.i4x4PredLeft = new int[4];
        this.topMBType = new MBType[mbWidth];
    }

    public void update(EncodedMB mb) {
        if (mb.getType() != MBType.I_NxN) {
            this.topLeft[0] = this.topLine[0][(mb.mbX << 4) + 15];
            System.arraycopy(mb.pixels.getPlaneData(0), 240, this.topLine[0], mb.mbX << 4, 16);
            this.copyCol(mb.pixels.getPlaneData(0), 15, 16, this.leftRow[0]);
        }
        this.topLeft[1] = this.topLine[1][(mb.mbX << 3) + 7];
        this.topLeft[2] = this.topLine[2][(mb.mbX << 3) + 7];
        System.arraycopy(mb.pixels.getPlaneData(1), 56, this.topLine[1], mb.mbX << 3, 8);
        System.arraycopy(mb.pixels.getPlaneData(2), 56, this.topLine[2], mb.mbX << 3, 8);
        this.copyCol(mb.pixels.getPlaneData(1), 7, 8, this.leftRow[1]);
        this.copyCol(mb.pixels.getPlaneData(2), 7, 8, this.leftRow[2]);
        this.mvTopLeftX = this.mvTopX[mb.mbX << 2];
        this.mvTopLeftY = this.mvTopY[mb.mbX << 2];
        this.mvTopLeftR = this.mvTopR[mb.mbX << 2];
        for (int i = 0; i < 4; ++i) {
            this.mvTopX[(mb.mbX << 2) + i] = mb.mx[12 + i];
            this.mvTopY[(mb.mbX << 2) + i] = mb.my[12 + i];
            this.mvTopR[(mb.mbX << 2) + i] = mb.mr[12 + i];
            this.mvLeftX[i] = mb.mx[i << 2];
            this.mvLeftY[i] = mb.my[i << 2];
            this.mvLeftR[i] = mb.mr[i << 2];
        }
        this.topMBType[mb.mbX] = this.leftMBType = mb.getType();
    }

    private void copyCol(byte[] planeData, int off, int stride, byte[] out) {
        for (int i = 0; i < out.length; ++i) {
            out[i] = planeData[off];
            off += stride;
        }
    }

    public EncodingContext fork() {
        EncodingContext ret = new EncodingContext(this.mbWidth, this.mbHeight);
        ret.cavlc = new CAVLC[3];
        for (int i = 0; i < 3; ++i) {
            System.arraycopy(this.leftRow[i], 0, ret.leftRow[i], 0, this.leftRow[i].length);
            System.arraycopy(this.topLine[i], 0, ret.topLine[i], 0, this.topLine[i].length);
            ret.topLeft[i] = this.topLeft[i];
            ret.cavlc[i] = this.cavlc[i].fork();
        }
        System.arraycopy(this.mvTopX, 0, ret.mvTopX, 0, ret.mvTopX.length);
        System.arraycopy(this.mvTopY, 0, ret.mvTopY, 0, ret.mvTopY.length);
        System.arraycopy(this.mvTopR, 0, ret.mvTopR, 0, ret.mvTopR.length);
        System.arraycopy(this.mvLeftX, 0, ret.mvLeftX, 0, ret.mvLeftX.length);
        System.arraycopy(this.mvLeftY, 0, ret.mvLeftY, 0, ret.mvLeftY.length);
        System.arraycopy(this.mvLeftR, 0, ret.mvLeftR, 0, ret.mvLeftR.length);
        ret.mvTopLeftX = this.mvTopLeftX;
        ret.mvTopLeftY = this.mvTopLeftY;
        ret.mvTopLeftR = this.mvTopLeftR;
        ret.prevQp = this.prevQp;
        if (this.mbWidth > 0) {
            System.arraycopy(this.topMBType, 0, ret.topMBType, 0, this.mbWidth);
        }
        ret.leftMBType = this.leftMBType;
        System.arraycopy(this.i4x4PredTop, 0, ret.i4x4PredTop, 0, this.mbWidth << 2);
        System.arraycopy(this.i4x4PredLeft, 0, ret.i4x4PredLeft, 0, 4);
        return ret;
    }
}

