/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.jcodec.codecs.h264.encode;

import li.cil.oc2.jcodec.codecs.h264.H264Const;
import li.cil.oc2.jcodec.codecs.h264.H264Encoder;
import li.cil.oc2.jcodec.codecs.h264.decode.CoeffTransformer;
import li.cil.oc2.jcodec.codecs.h264.decode.Intra4x4PredictionBuilder;
import li.cil.oc2.jcodec.codecs.h264.encode.EncodedMB;
import li.cil.oc2.jcodec.codecs.h264.encode.EncodingContext;
import li.cil.oc2.jcodec.codecs.h264.encode.MBEncoderHelper;
import li.cil.oc2.jcodec.codecs.h264.encode.MBWriterI16x16;
import li.cil.oc2.jcodec.codecs.h264.io.CAVLC;
import li.cil.oc2.jcodec.codecs.h264.io.model.MBType;
import li.cil.oc2.jcodec.codecs.h264.io.write.CAVLCWriter;
import li.cil.oc2.jcodec.common.io.BitWriter;
import li.cil.oc2.jcodec.common.model.Picture;
import li.cil.oc2.jcodec.common.tools.MathUtil;

public final class MBWriterINxN {
    public void encodeMacroblock(EncodingContext ctx, Picture pic, int mbX, int mbY, BitWriter out, EncodedMB outMB, int qp, H264Encoder.NonRdVector params) {
        for (int bInd = 0; bInd < 16; ++bInd) {
            int blkX = H264Const.MB_DISP_OFF_LEFT[bInd];
            int blkY = H264Const.MB_DISP_OFF_TOP[bInd];
            this.writePredictionI4x4Block(out, mbX > 0, mbY > 0, ctx.leftMBType, ctx.topMBType[mbX], blkX, blkY, mbX, ctx.i4x4PredTop, ctx.i4x4PredLeft, params.lumaPred4x4[bInd]);
        }
        int[][] coeff = new int[16][16];
        int cbpLuma = this.lumaAnal(ctx, pic, mbX, mbY, qp, outMB, params.lumaPred4x4, coeff);
        int cbpChroma = 2;
        int cbp = cbpLuma | 0x20;
        CAVLCWriter.writeUE(out, params.chrPred);
        CAVLCWriter.writeUE(out, H264Const.CODED_BLOCK_PATTERN_INTRA_COLOR_INV[cbp]);
        if (cbp != 0) {
            CAVLCWriter.writeSE(out, qp - ctx.prevQp);
        }
        outMB.setType(MBType.I_NxN);
        outMB.setQp(qp);
        this.lumaCode(ctx, mbX, mbY, out, outMB, coeff, cbpLuma);
        MBWriterI16x16.chroma(ctx, pic, mbX, mbY, MBType.I_NxN, out, qp, outMB.getPixels(), params.chrPred);
        ctx.prevQp = qp;
    }

    private void writePredictionI4x4Block(BitWriter out, boolean leftAvailable, boolean topAvailable, MBType leftMBType, MBType topMBType, int blkX, int blkY, int mbX, int[] i4x4PredTop, int[] i4x4PredLeft, int mode) {
        int predMode = 2;
        if ((leftAvailable || blkX > 0) && (topAvailable || blkY > 0)) {
            int predModeB = topMBType == MBType.I_NxN || blkY > 0 ? i4x4PredTop[(mbX << 2) + blkX] : 2;
            int predModeA = leftMBType == MBType.I_NxN || blkX > 0 ? i4x4PredLeft[blkY] : 2;
            predMode = Math.min(predModeB, predModeA);
        }
        boolean prev4x4PredMode = mode == predMode;
        out.write1Bit(prev4x4PredMode ? 1 : 0);
        if (!prev4x4PredMode) {
            int wrMode = mode - (mode > predMode ? 1 : 0);
            out.writeNBit(wrMode, 3);
        }
        i4x4PredTop[(mbX << 2) + blkX] = i4x4PredLeft[blkY] = mode;
    }

    private int lumaAnal(EncodingContext ctx, Picture pic, int mbX, int mbY, int qp, EncodedMB outMB, int[] predType, int[][] _coeff) {
        int cbp = 0;
        byte[] pred = new byte[16];
        int[] coeff = new int[16];
        byte[] tl = new byte[]{ctx.topLeft[0], ctx.leftRow[0][3], ctx.leftRow[0][7], ctx.leftRow[0][11]};
        for (int i8x8 = 0; i8x8 < 4; ++i8x8) {
            boolean hasNz = false;
            for (int i4x4 = 0; i4x4 < 4; ++i4x4) {
                int bIdx = (i8x8 << 2) + i4x4;
                int blkOffLeft = H264Const.MB_DISP_OFF_LEFT[bIdx];
                int blkOffTop = H264Const.MB_DISP_OFF_TOP[bIdx];
                int blkX = (mbX << 2) + blkOffLeft;
                int blkY = (mbY << 2) + blkOffTop;
                int dIdx = H264Const.BLK_DISP_MAP[bIdx];
                boolean hasLeft = (dIdx & 3) != 0 || mbX != 0;
                boolean hasTop = dIdx >= 4 || mbY != 0;
                boolean hasTr = (bIdx == 0 || bIdx == 1 || bIdx == 4) && mbY != 0 || bIdx == 5 && mbX < ctx.mbWidth - 1 || bIdx == 2 || bIdx == 6 || bIdx == 8 || bIdx == 9 || bIdx == 10 || bIdx == 12 || bIdx == 14;
                Intra4x4PredictionBuilder.lumaPred(predType[bIdx], hasLeft, hasTop, hasTr, ctx.leftRow[0], ctx.topLine[0], tl[blkOffTop], blkX << 2, blkOffTop << 2, pred);
                MBEncoderHelper.takeSubtract(pic.getPlaneData(0), pic.getPlaneWidth(0), pic.getPlaneHeight(0), blkX << 2, blkY << 2, coeff, pred, 4, 4);
                CoeffTransformer.fdct4x4(coeff);
                CoeffTransformer.quantizeAC(coeff, qp);
                System.arraycopy(coeff, 0, _coeff[bIdx], 0, 16);
                hasNz |= MBWriterI16x16.hasNz(coeff);
                CoeffTransformer.dequantizeAC(coeff, qp, null);
                CoeffTransformer.idct4x4(coeff);
                MBEncoderHelper.putBlk(outMB.pixels.getPlaneData(0), coeff, pred, 4, blkOffLeft << 2, blkOffTop << 2, 4, 4);
                tl[blkOffTop] = ctx.topLine[0][(blkX << 2) + 3];
                for (int p = 0; p < 4; ++p) {
                    ctx.leftRow[0][(blkOffTop << 2) + p] = (byte)MathUtil.clip(coeff[3 + (p << 2)] + pred[3 + (p << 2)], -128, 127);
                    ctx.topLine[0][(blkX << 2) + p] = (byte)MathUtil.clip(coeff[12 + p] + pred[12 + p], -128, 127);
                }
            }
            cbp |= (hasNz ? 1 : 0) << i8x8;
        }
        ctx.topLeft[0] = tl[0];
        return cbp;
    }

    private void lumaCode(EncodingContext ctx, int mbX, int mbY, BitWriter out, EncodedMB outMB, int[][] _coeff, int cbpLuma) {
        for (int i8x8 = 0; i8x8 < 4; ++i8x8) {
            int blkY;
            int blkX;
            int i4x4;
            int bx = mbX << 2 | i8x8 << 1 & 2;
            int by = mbY << 2 | i8x8 & 2;
            if ((cbpLuma & 1 << i8x8) != 0) {
                for (i4x4 = 0; i4x4 < 4; ++i4x4) {
                    blkX = bx | i4x4 & 1;
                    blkY = by | i4x4 >> 1 & 1;
                    int blkOffLeft = blkX & 3;
                    int blkOffTop = blkY & 3;
                    int bIdx = (i8x8 << 2) + i4x4;
                    int dIdx = H264Const.BLK_DISP_MAP[bIdx];
                    outMB.nc[dIdx] = CAVLC.totalCoeff(ctx.cavlc[0].writeACBlock(out, blkX, blkY, blkOffLeft == 0 ? ctx.leftMBType : MBType.I_NxN, blkOffTop == 0 ? ctx.topMBType[mbX] : MBType.I_NxN, _coeff[bIdx], H264Const.totalZeros16, 0, 16, CoeffTransformer.zigzag4x4));
                }
                continue;
            }
            for (i4x4 = 0; i4x4 < 4; ++i4x4) {
                blkX = bx | i4x4 & 1;
                blkY = by | i4x4 >> 1 & 1;
                ctx.cavlc[0].setZeroCoeff(blkX, blkY);
            }
        }
    }
}

