/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.jcodec.common.io;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import li.cil.oc2.jcodec.common.IntArrayList;
import li.cil.oc2.jcodec.common.io.BitReader;
import li.cil.oc2.jcodec.common.io.BitWriter;
import li.cil.oc2.jcodec.common.io.VLC;

public final class VLCBuilder {
    private final Int2IntArrayMap forward = new Int2IntArrayMap();
    private final Int2IntArrayMap inverse = new Int2IntArrayMap();
    private final IntArrayList codes = IntArrayList.createIntArrayList();
    private final IntArrayList codesSizes = IntArrayList.createIntArrayList();

    public VLCBuilder set(int val, String code) {
        return this.setInt(Integer.parseInt(code, 2), code.length(), val);
    }

    public VLCBuilder setInt(int code, int len, int val) {
        this.codes.add(code << 32 - len);
        this.codesSizes.add(len);
        this.forward.put(val, this.codes.size() - 1);
        this.inverse.put(this.codes.size() - 1, val);
        return this;
    }

    public VLC getVLC() {
        final VLCBuilder self = this;
        return new VLC(this.codes.toArray(), this.codesSizes.toArray()){

            @Override
            public int readVLC(BitReader _in) {
                return self.inverse.get(super.readVLC(_in));
            }

            @Override
            public int readVLC16(BitReader _in) {
                return self.inverse.get(super.readVLC16(_in));
            }

            @Override
            public void writeVLC(BitWriter out, int code) {
                super.writeVLC(out, self.forward.get(code));
            }
        };
    }
}

