/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.coroutil.util;

import java.util.List;
import net.minecraft.world.phys.Vec3;

public class CoroUtilPhysics {
    public static boolean isInConvexShape(Vec3 test, List<Vec3> nodes) {
        boolean result = false;
        int i = 0;
        int j = nodes.size() - 1;
        while (i < nodes.size()) {
            Vec3 vecI = nodes.get(i);
            Vec3 vecJ = nodes.get(j);
            if (vecI.f_82481_ > test.f_82481_ != vecJ.f_82481_ > test.f_82481_ && test.f_82479_ < (vecJ.f_82479_ - vecI.f_82479_) * (test.f_82481_ - vecI.f_82481_) / (vecJ.f_82481_ - vecI.f_82481_) + vecI.f_82479_) {
                result = !result;
            }
            j = i++;
        }
        return result;
    }

    public static double getDistanceToShape(Vec3 point, List<Vec3> nodes) {
        float closestDist1 = 9999.0f;
        float closestDist2 = 9999.0f;
        Vec3 closestPoint1 = null;
        Vec3 closestPoint2 = null;
        for (int i = 0; i < 2; ++i) {
            for (Vec3 pointTest : nodes) {
                double dist = pointTest.m_82554_(point);
                if (dist < (double)closestDist1) {
                    closestDist1 = (float)dist;
                    closestPoint1 = pointTest;
                    continue;
                }
                if (!(dist < (double)closestDist2) || pointTest == closestPoint1) continue;
                closestDist2 = (float)dist;
                closestPoint2 = pointTest;
            }
        }
        if (closestPoint1 == null || closestPoint2 == null) {
            return -1.0;
        }
        return CoroUtilPhysics.distBetweenPointAndLine(point.f_82479_, point.f_82481_, closestPoint1.f_82479_, closestPoint1.f_82481_, closestPoint2.f_82479_, closestPoint2.f_82481_);
    }

    public static double distBetweenPointAndLine(double x, double y, double x1, double y1, double x2, double y2) {
        double AB = CoroUtilPhysics.distBetween(x, y, x1, y1);
        double BC = CoroUtilPhysics.distBetween(x1, y1, x2, y2);
        double AC = CoroUtilPhysics.distBetween(x, y, x2, y2);
        double s = (AB + BC + AC) / 2.0;
        double area = Math.sqrt(s * (s - AB) * (s - BC) * (s - AC));
        double AD = 2.0 * area / BC;
        return AD;
    }

    public static double distBetween(double x, double y, double x1, double y1) {
        double xx = x1 - x;
        double yy = y1 - y;
        return Math.sqrt(xx * xx + yy * yy);
    }
}

