/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.cultivation;

import cofh.core.common.config.IBaseConfig;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.cultivation.common.config.TCulToolConfig;
import cofh.thermal.cultivation.common.config.ThermalCropConfig;
import cofh.thermal.cultivation.common.loot.GrassLootModifier;
import cofh.thermal.cultivation.init.registries.TCulBlockEntities;
import cofh.thermal.cultivation.init.registries.TCulBlocks;
import cofh.thermal.cultivation.init.registries.TCulItems;
import cofh.thermal.lib.util.ThermalFlags;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="thermal_cultivation")
public class ThermalCultivation {
    public ThermalCultivation() {
        this.setFeatureFlags();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ThermalCore.CONFIG_MANAGER.register(modEventBus).addServerConfig((IBaseConfig)new ThermalCropConfig()).addServerConfig((IBaseConfig)new TCulToolConfig());
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        TCulBlocks.register();
        TCulItems.register();
        TCulBlockEntities.register();
        ThermalCore.LOOT_SERIALIZERS.register("seeds_from_grass", () -> GrassLootModifier.CODEC);
    }

    private void setFeatureFlags() {
        ThermalFlags.setFlag((String)ThermalFlags.FLAG_RESOURCE_APATITE, (boolean)true);
        ThermalFlags.setFlag((String)ThermalFlags.FLAG_AREA_AUGMENTS, (boolean)true);
        ThermalFlags.setFlag((String)ThermalFlags.FLAG_BEEKEEPER_ARMOR, (boolean)true);
        ThermalFlags.setFlag((String)ThermalFlags.FLAG_PHYTOGRO_EXPLOSIVES, (boolean)true);
        ThermalFlags.setFlag((String)"device_hive_extractor", (boolean)true);
        ThermalFlags.setFlag((String)"device_tree_extractor", (boolean)true);
        ThermalFlags.setFlag((String)"device_fisher", (boolean)true);
        ThermalFlags.setFlag((String)"device_composter", (boolean)true);
        ThermalFlags.setFlag((String)"device_soil_infuser", (boolean)true);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(TCulBlocks::setup);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(this::registerRenderLayers);
    }

    private void registerRenderLayers() {
        RenderType cutout = RenderType.m_110463_();
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("amaranth")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("barley")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("corn")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("flax")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("onion")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("radish")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("rice")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("sadiroot")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("spinach")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("bell_pepper")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("eggplant")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("green_bean")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("peanut")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("strawberry")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("tomato")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("coffee")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("tea")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("glowstone_mushroom")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("gunpowder_mushroom")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("redstone_mushroom")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("slime_mushroom")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("frost_melon_stem")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("frost_melon_stem_attached")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("potion_cake")), (RenderType)cutout);
    }
}

