/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks;

import java.util.Collections;
import java.util.List;
import net.jacobwasbeast.picaxe.blocks.entities.ImageFrameBlockEntity;
import net.jacobwasbeast.picaxe.blocks.entities.SixSidedImageBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ImageFrameBlock
extends DirectionalBlock
implements EntityBlock {
    public ImageFrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)context.m_43719_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ImageFrameBlockEntity(pos, state);
    }

    public VoxelShape m_7952_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        Direction facing = (Direction)blockState.m_61143_((Property)f_52588_);
        float frameWidthScale = 1.0f;
        float frameHeightScale = 1.0f;
        BlockEntity be = blockGetter.m_7702_(blockPos);
        if (be instanceof ImageFrameBlockEntity) {
            ImageFrameBlockEntity imageFrame = (ImageFrameBlockEntity)be;
            frameWidthScale = imageFrame.getFrameWidth();
            frameHeightScale = imageFrame.getFrameHeight();
        }
        double width = (double)frameWidthScale * 16.0;
        double height = (double)frameHeightScale * 16.0;
        double xOffset = (16.0 - width) / 2.0;
        double yOffset = (16.0 - height) / 2.0;
        double zOffsetForWidth = (16.0 - width) / 2.0;
        double zOffsetForHeight = (16.0 - height) / 2.0;
        switch (facing) {
            case NORTH: {
                return Block.m_49796_((double)xOffset, (double)yOffset, (double)15.0, (double)(16.0 - xOffset), (double)(16.0 - yOffset), (double)16.0);
            }
            case SOUTH: {
                return Block.m_49796_((double)xOffset, (double)yOffset, (double)0.0, (double)(16.0 - xOffset), (double)(16.0 - yOffset), (double)1.0);
            }
            case WEST: {
                return Block.m_49796_((double)15.0, (double)yOffset, (double)zOffsetForWidth, (double)16.0, (double)(16.0 - yOffset), (double)(16.0 - zOffsetForWidth));
            }
            case EAST: {
                return Block.m_49796_((double)0.0, (double)yOffset, (double)zOffsetForWidth, (double)1.0, (double)(16.0 - yOffset), (double)(16.0 - zOffsetForWidth));
            }
            case DOWN: {
                return Block.m_49796_((double)xOffset, (double)15.0, (double)zOffsetForHeight, (double)(16.0 - xOffset), (double)16.0, (double)(16.0 - zOffsetForHeight));
            }
            case UP: {
                return Block.m_49796_((double)xOffset, (double)0.0, (double)zOffsetForHeight, (double)(16.0 - xOffset), (double)1.0, (double)(16.0 - zOffsetForHeight));
            }
        }
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.m_5940_(blockState, blockGetter, blockPos, collisionContext);
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        BlockEntity adjacentBlockEntity = level.m_7702_(blockPos.m_121945_(((Direction)blockState.m_61143_((Property)f_52588_)).m_122424_()));
        if (adjacentBlockEntity instanceof SixSidedImageBlockEntity) {
            level.m_7731_(blockPos, blockState2, 3);
            ItemEntity itemEntity = new ItemEntity(level, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, new ItemStack((ItemLike)this));
            itemEntity.m_32060_();
            itemEntity.m_32064_();
            level.m_7967_((Entity)itemEntity);
        } else {
            super.m_6807_(blockState, level, blockPos, blockState2, bl);
        }
    }

    public List<ItemStack> m_49635_(BlockState blockState, LootParams.Builder builder) {
        BlockEntity blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof ImageFrameBlockEntity) {
            ImageFrameBlockEntity frameEntity = (ImageFrameBlockEntity)blockEntity;
            ItemStack itemStackToDrop = new ItemStack((ItemLike)frameEntity.m_58900_().m_60734_());
            return Collections.singletonList(itemStackToDrop);
        }
        return super.m_49635_(blockState, builder);
    }
}

