/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks.entities;

import net.jacobwasbeast.picaxe.ModBlockEntities;
import net.jacobwasbeast.picaxe.api.ImageFrameAlignment;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ImageFrameBlockEntity
extends BlockEntity {
    private String imageUrl = "";
    private int frameWidth = 1;
    private int frameHeight = 1;
    private boolean stretchToFit = false;
    private ImageFrameAlignment alignment = ImageFrameAlignment.CENTER;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double offsetZ = 0.0;

    public ImageFrameBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.IMAGE_FRAME_BLOCK_ENTITY.get(), pos, state);
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public int getFrameWidth() {
        return this.frameWidth;
    }

    public int getFrameHeight() {
        return this.frameHeight;
    }

    public boolean shouldStretchToFit() {
        return this.stretchToFit;
    }

    public ImageFrameAlignment getAlignment() {
        return this.alignment;
    }

    public void setConfiguration(String url, int width, int height, boolean stretch, ImageFrameAlignment alignment, double offsetX, double offsetY, double offsetZ) {
        this.imageUrl = url;
        this.frameWidth = Mth.m_14045_((int)width, (int)1, (int)6);
        this.frameHeight = Mth.m_14045_((int)height, (int)1, (int)6);
        this.stretchToFit = stretch;
        this.alignment = alignment;
        this.offsetX = Mth.m_14008_((double)offsetX, (double)-16.0, (double)16.0);
        this.offsetY = Mth.m_14008_((double)offsetY, (double)-16.0, (double)16.0);
        this.offsetZ = Mth.m_14008_((double)offsetZ, (double)-16.0, (double)16.0);
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("id", "picaxe:image_frame");
        tag.m_128359_("imageUrl", this.imageUrl);
        tag.m_128405_("frameWidth", this.frameWidth);
        tag.m_128405_("frameHeight", this.frameHeight);
        tag.m_128379_("stretchToFit", this.stretchToFit);
        tag.m_128359_("alignment", this.alignment.name());
        tag.m_128347_("offsetX", this.offsetX);
        tag.m_128347_("offsetY", this.offsetY);
        tag.m_128347_("offsetZ", this.offsetZ);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.imageUrl = tag.m_128461_("imageUrl");
        this.frameWidth = tag.m_128451_("frameWidth");
        this.frameHeight = tag.m_128451_("frameHeight");
        this.stretchToFit = tag.m_128471_("stretchToFit");
        if (tag.m_128441_("alignment")) {
            try {
                this.alignment = ImageFrameAlignment.valueOf(tag.m_128461_("alignment"));
            }
            catch (IllegalArgumentException e) {
                this.alignment = ImageFrameAlignment.CENTER;
            }
        }
        this.offsetX = tag.m_128459_("offsetX");
        this.offsetY = tag.m_128459_("offsetY");
        this.offsetZ = tag.m_128459_("offsetZ");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public double getOffsetZ() {
        return this.offsetZ;
    }
}

