/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.jacobwasbeast.picaxe.api.ImageFrameAlignment;
import net.jacobwasbeast.picaxe.blocks.ImageFrameBlock;
import net.jacobwasbeast.picaxe.blocks.entities.ImageFrameBlockEntity;
import net.jacobwasbeast.picaxe.utils.ImageUtils;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class ImageFrameBlockRenderer
implements BlockEntityRenderer<ImageFrameBlockEntity> {
    private static final ResourceLocation OAK_WALL_TEXTURE = ResourceLocation.m_214293_((String)"minecraft", (String)"textures/block/oak_planks.png");

    public ImageFrameBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ImageFrameBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        BlockState blockState = blockEntity.m_58900_();
        Direction facing = (Direction)blockState.m_61143_((Property)ImageFrameBlock.f_52588_);
        float frameWidth = blockEntity.getFrameWidth();
        float frameHeight = blockEntity.getFrameHeight();
        ImageFrameAlignment alignment = blockEntity.getAlignment();
        Vector2f anchor = ImageFrameBlockRenderer.computeAnchorOffset(alignment, frameWidth, frameHeight);
        float offX = (float)blockEntity.getOffsetX();
        float offY = (float)blockEntity.getOffsetY();
        float offZ = (float)blockEntity.getOffsetZ();
        Basis faceBasis = ImageFrameBlockRenderer.basisFor(facing);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        switch (facing) {
            case DOWN: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                break;
            }
            case UP: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                break;
            }
            case NORTH: {
                break;
            }
            case SOUTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case EAST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            }
        }
        poseStack.m_85836_();
        float localZ = 0.499f - offZ;
        poseStack.m_252880_(anchor.x + offX, anchor.y + offY, localZ);
        int light = ImageFrameBlockRenderer.sampleLightAt(level, blockEntity.m_58899_(), faceBasis, anchor.x + offX, anchor.y + offY, localZ);
        this.renderDoubleSidedQuad(poseStack, bufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)OAK_WALL_TEXTURE)), frameWidth, frameHeight, light, packedOverlay, 220, false);
        poseStack.m_85849_();
        String imageUrl = blockEntity.getImageUrl();
        if (imageUrl != null && !imageUrl.isBlank()) {
            boolean keepAspectRatio = !blockEntity.shouldStretchToFit();
            poseStack.m_85836_();
            float localZ2 = 0.018f - offZ;
            poseStack.m_252880_(anchor.x + offX, anchor.y + offY, localZ2);
            poseStack.m_252781_(Axis.f_252495_.m_252977_(-90.0f));
            poseStack.m_252781_(Axis.f_252495_.m_252977_(-180.0f));
            poseStack.m_85837_(0.0, -0.99, 0.0);
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            int faceLight = ImageFrameBlockRenderer.sampleLightAt(level, blockEntity.m_58899_(), faceBasis, anchor.x + offX, anchor.y + offY, localZ2);
            ImageUtils.renderImageFromURL(poseStack, bufferSource, faceLight, packedOverlay, partialTick, frameWidth, frameHeight, imageUrl, keepAspectRatio);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private static Vector2f computeAnchorOffset(ImageFrameAlignment a, float width, float height) {
        int hx = switch (a) {
            default -> throw new IncompatibleClassChangeError();
            case ImageFrameAlignment.TOP_LEFT, ImageFrameAlignment.CENTER_LEFT, ImageFrameAlignment.BOTTOM_LEFT -> -1;
            case ImageFrameAlignment.TOP_CENTER, ImageFrameAlignment.CENTER, ImageFrameAlignment.BOTTOM_CENTER -> 0;
            case ImageFrameAlignment.TOP_RIGHT, ImageFrameAlignment.CENTER_RIGHT, ImageFrameAlignment.BOTTOM_RIGHT -> 1;
        };
        int vy = switch (a) {
            default -> throw new IncompatibleClassChangeError();
            case ImageFrameAlignment.TOP_LEFT, ImageFrameAlignment.TOP_CENTER, ImageFrameAlignment.TOP_RIGHT -> -1;
            case ImageFrameAlignment.CENTER_LEFT, ImageFrameAlignment.CENTER, ImageFrameAlignment.CENTER_RIGHT -> 0;
            case ImageFrameAlignment.BOTTOM_LEFT, ImageFrameAlignment.BOTTOM_CENTER, ImageFrameAlignment.BOTTOM_RIGHT -> 1;
        };
        float cx = (float)hx * (0.5f - width / 2.0f);
        float cy = (float)vy * (0.5f - height / 2.0f);
        return new Vector2f(cx, cy);
    }

    private static Basis basisFor(Direction face) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> new Basis(new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f));
            case Direction.SOUTH -> new Basis(new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f));
            case Direction.WEST -> new Basis(new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f));
            case Direction.EAST -> new Basis(new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f));
            case Direction.UP -> new Basis(new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 1.0f, 0.0f));
            case Direction.DOWN -> new Basis(new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, -1.0f, 0.0f));
        };
    }

    private static int sampleLightAt(Level level, BlockPos origin, Basis basis, float dx, float dy, float dz) {
        double cx = (double)origin.m_123341_() + 0.5;
        double cy = (double)origin.m_123342_() + 0.5;
        double cz = (double)origin.m_123343_() + 0.5;
        double wx = cx + (double)(dx * basis.u().x()) + (double)(dy * basis.v().x()) + (double)(dz * basis.n().x());
        double wy = cy + (double)(dx * basis.u().y()) + (double)(dy * basis.v().y()) + (double)(dz * basis.n().y());
        double wz = cz + (double)(dx * basis.u().z()) + (double)(dy * basis.v().z()) + (double)(dz * basis.n().z());
        float EPS = 0.001f;
        BlockPos sample = BlockPos.m_274561_((double)(wx += (double)(0.001f * basis.n().x())), (double)(wy += (double)(0.001f * basis.n().y())), (double)(wz += (double)(0.001f * basis.n().z())));
        return LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)sample);
    }

    private void renderDoubleSidedQuad(PoseStack poseStack, VertexConsumer vc, float width, float height, int light, int overlay, int color, boolean useNormalizedUV) {
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix = pose.m_252922_();
        Vector3f normalPositiveZ = new Vector3f(0.0f, 0.0f, 1.0f);
        matrix.transformDirection(normalPositiveZ);
        Vector3f normalNegativeZ = new Vector3f(0.0f, 0.0f, -1.0f);
        matrix.transformDirection(normalNegativeZ);
        float x0 = -width / 2.0f;
        float x1 = width / 2.0f;
        float y0 = -height / 2.0f;
        float y1 = height / 2.0f;
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = width * 16.0f;
        float v1 = height * 16.0f;
        Vector3f v_tl = new Vector3f(x0, y1, 0.0f);
        v_tl.mulPosition((Matrix4fc)matrix);
        Vector3f v_bl = new Vector3f(x0, y0, 0.0f);
        v_bl.mulPosition((Matrix4fc)matrix);
        Vector3f v_br = new Vector3f(x1, y0, 0.0f);
        v_br.mulPosition((Matrix4fc)matrix);
        Vector3f v_tr = new Vector3f(x1, y1, 0.0f);
        v_tr.mulPosition((Matrix4fc)matrix);
        vc.m_5483_((double)v_tl.x(), (double)v_tl.y(), (double)v_tl.z()).m_6122_(color, color, color, 255).m_7421_(u0, v0).m_86008_(overlay).m_85969_(light).m_5601_(normalPositiveZ.x(), normalPositiveZ.y(), normalPositiveZ.z()).m_5752_();
        vc.m_5483_((double)v_bl.x(), (double)v_bl.y(), (double)v_bl.z()).m_6122_(color, color, color, 255).m_7421_(u0, v1).m_86008_(overlay).m_85969_(light).m_5601_(normalPositiveZ.x(), normalPositiveZ.y(), normalPositiveZ.z()).m_5752_();
        vc.m_5483_((double)v_br.x(), (double)v_br.y(), (double)v_br.z()).m_6122_(color, color, color, 255).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_5601_(normalPositiveZ.x(), normalPositiveZ.y(), normalPositiveZ.z()).m_5752_();
        vc.m_5483_((double)v_tr.x(), (double)v_tr.y(), (double)v_tr.z()).m_6122_(color, color, color, 255).m_7421_(u1, v0).m_86008_(overlay).m_85969_(light).m_5601_(normalPositiveZ.x(), normalPositiveZ.y(), normalPositiveZ.z()).m_5752_();
        vc.m_5483_((double)v_tr.x(), (double)v_tr.y(), (double)v_tr.z()).m_6122_(color, color, color, 255).m_7421_(u1, v0).m_86008_(overlay).m_85969_(light).m_5601_(normalNegativeZ.x(), normalNegativeZ.y(), normalNegativeZ.z()).m_5752_();
        vc.m_5483_((double)v_br.x(), (double)v_br.y(), (double)v_br.z()).m_6122_(color, color, color, 255).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_5601_(normalNegativeZ.x(), normalNegativeZ.y(), normalNegativeZ.z()).m_5752_();
        vc.m_5483_((double)v_bl.x(), (double)v_bl.y(), (double)v_bl.z()).m_6122_(color, color, color, 255).m_7421_(u0, v1).m_86008_(overlay).m_85969_(light).m_5601_(normalNegativeZ.x(), normalNegativeZ.y(), normalNegativeZ.z()).m_5752_();
        vc.m_5483_((double)v_tl.x(), (double)v_tl.y(), (double)v_tl.z()).m_6122_(color, color, color, 255).m_7421_(u0, v0).m_86008_(overlay).m_85969_(light).m_5601_(normalNegativeZ.x(), normalNegativeZ.y(), normalNegativeZ.z()).m_5752_();
    }

    private record Basis(Vector3f u, Vector3f v, Vector3f n) {
    }
}

