/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.gui;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.jacobwasbeast.picaxe.items.PicAxeItem;
import net.jacobwasbeast.picaxe.network.UpdatePicAxeUrlPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class URLInputScreen
extends Screen {
    private static final int BACKGROUND_COLOR = -436207616;
    private static final int PANEL_COLOR = -870967786;
    private static final int ACCENT_COLOR = -11688961;
    private static final int TEXT_COLOR = -1;
    private static final int SUBTITLE_COLOR = -6643546;
    private static final int ERROR_COLOR = -42389;
    private static final int SUCCESS_COLOR = -13710223;
    private final InteractionHand hand;
    private EditBox urlInput;
    private String currentUrl;
    private String errorMessage = "";
    private int errorTimer = 0;
    private int panelX;
    private int panelY;
    private int panelWidth;
    private int panelHeight;
    private final List<Chip> chips = new ArrayList<Chip>();

    public URLInputScreen(Player player, InteractionHand hand) {
        super((Component)Component.m_237115_((String)"picaxe.screen.url_input.title"));
        this.hand = hand;
        ItemStack itemStack = player.m_21120_(hand);
        this.currentUrl = PicAxeItem.getURL(itemStack);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.chips.clear();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        this.panelWidth = 420;
        this.panelHeight = 190;
        this.panelX = centerX - this.panelWidth / 2;
        this.panelY = centerY - this.panelHeight / 2;
        this.urlInput = new EditBox(this.f_96547_, this.panelX + 30, this.panelY + 65, this.panelWidth - 120, 22, (Component)Component.m_237115_((String)"picaxe.screen.url_input.url"));
        this.urlInput.m_94199_(256);
        this.urlInput.m_94144_(this.currentUrl);
        this.urlInput.m_257771_((Component)Component.m_237115_((String)"picaxe.screen.url_input.hint"));
        this.urlInput.m_94182_(false);
        this.urlInput.m_94151_(text -> this.validateInput());
        this.addChip(this.panelX + this.panelWidth - 80, this.panelY + 65, 22, 22, (Component)Component.m_237113_((String)"\u2398"), true, () -> {
            String clip = Minecraft.m_91087_().f_91068_.m_90876_();
            if (clip != null) {
                this.urlInput.m_94144_(clip.trim());
                this.validateInput();
            }
        });
        this.addChip(this.panelX + this.panelWidth - 54, this.panelY + 65, 22, 22, (Component)Component.m_237113_((String)"\u2715"), false, () -> {
            this.urlInput.m_94144_("");
            this.validateInput();
        });
        int bw = (this.panelWidth - 90) / 2;
        this.addChip(this.panelX + 30, this.panelY + 135, bw, 24, (Component)Component.m_237115_((String)"picaxe.screen.url_input.confirm_button"), true, this::submitIfValid);
        this.addChip(this.panelX + 30 + bw + 30, this.panelY + 135, bw, 24, (Component)Component.m_237115_((String)"picaxe.screen.url_input.cancel_button"), false, () -> this.f_96541_.m_91152_(null));
        this.m_7787_((GuiEventListener)this.urlInput);
        this.m_264313_((GuiEventListener)this.urlInput);
        this.validateInput();
    }

    private void addChip(int x, int y, int w, int h, Component label, boolean primary, Runnable action) {
        int bg = primary ? -13934337 : -14736599;
        int bgHover = primary ? -12882689 : -14275790;
        this.chips.add(new Chip(x, y, w, h, label, bg, bgHover, -1, primary, action));
    }

    private boolean validateInput() {
        boolean ok;
        String url = this.urlInput.m_94155_().trim();
        if (url.isEmpty()) {
            this.errorMessage = "";
            return true;
        }
        boolean bl = ok = url.startsWith("http://") || url.startsWith("https://") || url.startsWith("file://") || url.endsWith(".png") || url.endsWith(".jpg") || url.endsWith(".jpeg") || url.endsWith(".gif") || url.endsWith(".webp");
        if (!ok) {
            this.errorMessage = Component.m_237115_((String)"picaxe.screen.url_input.error.invalid").getString();
            this.errorTimer = 60;
        } else {
            this.errorMessage = "";
        }
        return ok;
    }

    private void submitIfValid() {
        if (!this.validateInput()) {
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        UpdatePicAxeUrlPayload payload = new UpdatePicAxeUrlPayload(this.urlInput.m_94155_().trim(), this.hand);
        payload.write(buf);
        NetworkManager.sendToServer((ResourceLocation)UpdatePicAxeUrlPayload.TYPE, (FriendlyByteBuf)buf);
        this.f_96541_.m_91152_(null);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (Chip c : this.chips) {
            if (!c.hit(mouseX, mouseY)) continue;
            c.action.run();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        String clip;
        if (keyCode == 257 || keyCode == 335) {
            this.submitIfValid();
            return true;
        }
        if (keyCode == 256) {
            this.f_96541_.m_91152_(null);
            return true;
        }
        if ((modifiers & 2) != 0 && keyCode == 86 && (clip = Minecraft.m_91087_().f_91068_.m_90876_()) != null) {
            this.urlInput.m_94144_(clip.trim());
            this.validateInput();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.errorTimer > 0) {
            --this.errorTimer;
        }
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        gui.m_280509_(0, 0, this.f_96543_, this.f_96544_, -436207616);
        gui.m_280509_(this.panelX + 3, this.panelY + 3, this.panelX + this.panelWidth + 3, this.panelY + this.panelHeight + 3, 0x30000000);
        gui.m_280509_(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + this.panelHeight, -870967786);
        gui.m_280509_(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + 3, -11688961);
        gui.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, this.panelY + 12, -1);
        gui.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"picaxe.screen.url_input.subtitle"), this.f_96543_ / 2, this.panelY + 28, -6643546);
        gui.m_280509_(this.panelX + 30, this.panelY + 50, this.panelX + this.panelWidth - 30, this.panelY + 51, 0x36FFFFFF);
        this.drawInput(gui, this.panelX + 30, this.panelY + 65, this.panelWidth - 120, 22, this.urlInput.m_93696_());
        gui.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"picaxe.screen.url_input.label"), this.panelX + 30, this.panelY + 52, -6643546);
        if (!this.currentUrl.isEmpty() && !this.currentUrl.equals(this.urlInput.m_94155_().trim())) {
            MutableComponent currentLabel = Component.m_237110_((String)"picaxe.screen.url_input.current", (Object[])new Object[]{this.currentUrl.length() > 44 ? this.currentUrl.substring(0, 41) + "..." : this.currentUrl});
            gui.m_280430_(this.f_96547_, (Component)currentLabel, this.panelX + 30, this.panelY + 94, -9539986);
            gui.m_280509_(this.panelX + 14, this.panelY + 65, this.panelX + 16, this.panelY + 87, -13710223);
        }
        for (Chip c : this.chips) {
            boolean hover = c.hit(mouseX, mouseY);
            gui.m_280509_(c.x, c.y, c.x + c.w, c.y + c.h, hover ? c.bgHover : c.bg);
            gui.m_280653_(this.f_96547_, c.label, c.x + c.w / 2, c.y + (c.h - 8) / 2, c.fg);
        }
        if (this.errorTimer > 0 && !this.errorMessage.isEmpty()) {
            int errorAlpha = Math.min(255, this.errorTimer * 255 / 60);
            int errorColor = errorAlpha << 24 | 0xFF5A6B;
            gui.m_280137_(this.f_96547_, this.errorMessage, this.f_96543_ / 2, this.panelY + 112, errorColor);
        }
        super.m_88315_(gui, mouseX, mouseY, partialTick);
        this.urlInput.m_88315_(gui, mouseX, mouseY, partialTick);
    }

    private void drawInput(GuiGraphics g, int x, int y, int w, int h, boolean focused) {
        int bg = focused ? -14539736 : -15066338;
        int bd = focused ? -11688961 : -14013392;
        g.m_280509_(x, y, x + w, y + h, bg);
        g.m_280509_(x - 1, y - 1, x + w + 1, y, bd);
        g.m_280509_(x - 1, y + h, x + w + 1, y + h + 1, bd);
        g.m_280509_(x - 1, y, x, y + h, bd);
        g.m_280509_(x + w, y, x + w + 1, y + h, bd);
    }

    public boolean m_7043_() {
        return false;
    }

    private static class Chip {
        int x;
        int y;
        int w;
        int h;
        Runnable action;
        Component label;
        int bg;
        int bgHover;
        int fg;
        boolean primary;

        Chip(int x, int y, int w, int h, Component label, int bg, int bgHover, int fg, boolean primary, Runnable action) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.label = label;
            this.bg = bg;
            this.bgHover = bgHover;
            this.fg = fg;
            this.primary = primary;
            this.action = action;
        }

        boolean hit(double mx, double my) {
            return mx >= (double)this.x && my >= (double)this.y && mx <= (double)(this.x + this.w) && my <= (double)(this.y + this.h);
        }
    }
}

