/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.recipe;

import net.jacobwasbeast.picaxe.ModItems;
import net.jacobwasbeast.picaxe.ModRecipes;
import net.jacobwasbeast.picaxe.blocks.entities.SixSidedImageBlockEntity;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SixSidedImageBlockCloneRecipe
extends CustomRecipe {
    public SixSidedImageBlockCloneRecipe(ResourceLocation resourceLocation, CraftingBookCategory craftingBookCategory) {
        super(resourceLocation, craftingBookCategory);
    }

    @Nullable
    private RecipeAnalysis analyze(CraftingContainer inv) {
        int sourceSlot = -1;
        ItemStack sourceStack = null;
        ItemStack targetStack = null;
        int count = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            ++count;
            if (!stack.m_150930_((Item)ModItems.SIX_SIDED_IMAGE_BLOCK_ITEM.get())) {
                return null;
            }
            if (sourceStack == null) {
                sourceSlot = i;
                sourceStack = stack;
                continue;
            }
            targetStack = stack;
        }
        if (count == 2 && sourceStack != null && targetStack != null && sourceStack.m_41613_() == 1) {
            return new RecipeAnalysis(sourceSlot, sourceStack, targetStack);
        }
        return null;
    }

    public boolean matches(CraftingContainer inv, Level level) {
        return this.analyze(inv) != null;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess regs) {
        RecipeAnalysis analysis = this.analyze(inv);
        if (analysis == null) {
            return ItemStack.f_41583_;
        }
        SixSidedImageBlockEntity beSrc = SixSidedImageBlockEntity.fromItemStack(analysis.sourceStack);
        ItemStack result = analysis.targetStack.m_41777_();
        SixSidedImageBlockEntity beResult = SixSidedImageBlockEntity.fromItemStack(result);
        for (Direction d : Direction.values()) {
            beResult.setImageUrl(d, beSrc.getImages().get(d));
        }
        return beResult.createItemStack();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        RecipeAnalysis analysis = this.analyze(inv);
        NonNullList remainingItems = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        if (analysis != null) {
            remainingItems.set(analysis.sourceSlot, (Object)analysis.sourceStack.m_41777_());
        }
        return remainingItems;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SIX_SIDED_IMAGE_BLOCK_ITEM.get()}));
        ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SIX_SIDED_IMAGE_BLOCK_ITEM.get()}));
        return ingredients;
    }

    public boolean m_8004_(int w, int h) {
        return w * h >= 2;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return new ItemStack((ItemLike)ModItems.SIX_SIDED_IMAGE_BLOCK_ITEM.get());
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.SIX_SIDED_IMAGE_CLONE_RECIPE_SERIALIZER.get();
    }

    private record RecipeAnalysis(int sourceSlot, ItemStack sourceStack, ItemStack targetStack) {
    }
}

