/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.block;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.tile.BatteryBoxBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class BatteryBoxBlock
extends ProjectRedBlock {
    public static final IntegerProperty CHARGE_LEVEL = IntegerProperty.m_61631_((String)"charge_level", (int)0, (int)8);

    public BatteryBoxBlock() {
        super(WOODEN_MACHINE_PROPERTIES);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BatteryBoxBlockEntity(pos, state);
    }

    protected BlockEntityType<?> getBlockEntityType() {
        return (BlockEntityType)ExpansionBlocks.BATTERY_BOX_BLOCK_ENTITY.get();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)CHARGE_LEVEL, (Comparable)Integer.valueOf(0));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CHARGE_LEVEL});
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        BlockEntity tile = (BlockEntity)builder.m_287261_(LootContextParams.f_81462_);
        if (tile instanceof BatteryBoxBlockEntity) {
            BatteryBoxBlockEntity batteryBoxTile = (BatteryBoxBlockEntity)tile;
            return Collections.singletonList(batteryBoxTile.createStackWithStoredPower());
        }
        return super.m_49635_(state, builder);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof BatteryBoxBlockEntity) {
            return ((BatteryBoxBlockEntity)tile).createStackWithStoredPower();
        }
        return super.getCloneItemStack(state, target, world, pos, player);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> toolTip, TooltipFlag flag) {
        super.m_5871_(stack, level, toolTip, flag);
        if (stack.m_41782_()) {
            int power = Objects.requireNonNull(stack.m_41783_()).m_128451_("power_stored");
            toolTip.add((Component)Component.m_237115_((String)"projectred-expansion.tooltip.charge_level").m_130946_(": " + power + " / 8000").m_130940_(ChatFormatting.GRAY));
        }
    }
}

