/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.data;

import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.expansion.block.BatteryBoxBlock;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ExpansionBlockStateModelProvider
extends BlockStateProvider {
    private static final int[][] DEVICE_SIDED_ROTATIONS = new int[][]{{0, 0}, {2, 2}, {1, 2}, {1, 0}, {1, 1}, {1, 3}};

    public ExpansionBlockStateModelProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "projectred_expansion", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.addRotatableOppositeMatchingFacesBlock((Block)ExpansionBlocks.PROJECT_BENCH_BLOCK.get());
        this.addBatteryBoxBlock((Block)ExpansionBlocks.BATTERY_BOX_BLOCK.get());
        this.addTriStateFrontFacedPoweredMachineBlock((Block)ExpansionBlocks.AUTO_CRAFTER_BLOCK.get());
        this.addBiStateSideAndTopMachineBlock((Block)ExpansionBlocks.CHARGING_BENCH_BLOCK.get());
        this.addSidedOppositeMatchingFacesDeviceBlock((Block)ExpansionBlocks.FIRE_STARTER_BLOCK.get());
        this.addTriStateSidedPoweredDeviceBlock((Block)ExpansionBlocks.FRAME_ACTUATOR_BLOCK.get());
        this.addSideAndTopActiveModel((Block)ExpansionBlocks.TRANSPOSER_BLOCK.get());
        this.addSideAndTopActiveModel((Block)ExpansionBlocks.BLOCK_BREAKER_BLOCK.get());
        this.addSidedOppositeMatchingFacesDeviceBlock((Block)ExpansionBlocks.DEPLOYER_BLOCK.get());
        this.addProgrammaticWithParticleTexture((Block)ExpansionBlocks.FRAME_BLOCK.get(), "");
        this.addProgrammaticWithParticleTexture((Block)ExpansionBlocks.FRAME_MOTOR_BLOCK.get(), "_top");
    }

    private void addProgrammaticWithParticleTexture(Block block, String texSuffix) {
        String blockName = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        String texName = blockName + texSuffix;
        ModelBuilder dummy = ((BlockModelBuilder)this.models().withExistingParent(blockName + "_programmatically_rendered", "block")).texture("particle", "block/" + texName);
        this.simpleBlock(block, (ModelFile)dummy);
    }

    private void addRotatableOppositeMatchingFacesBlock(Block block) {
        this.addRotatableVariants(block, (ModelFile)this.createOppositeMatchingFaceModel(block));
    }

    private void addBatteryBoxBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int charge = (Integer)state.m_61143_((Property)BatteryBoxBlock.CHARGE_LEVEL);
            return ConfiguredModel.builder().modelFile((ModelFile)this.createBatteryModel(block, charge)).build();
        });
    }

    private void addTriStateFrontFacedPoweredMachineBlock(Block block) {
        BlockModelBuilder m0 = this.createFrontFacedMachineModel(block, 0);
        BlockModelBuilder m1 = this.createFrontFacedMachineModel(block, 1);
        BlockModelBuilder m3 = this.createFrontFacedMachineModel(block, 2);
        this.addRotatablePoweredMachineVariants(block, (ModelFile)m0, (ModelFile)m1, (ModelFile)m1, (ModelFile)m3);
    }

    private void addBiStateSideAndTopMachineBlock(Block block) {
        BlockModelBuilder m0 = this.createSideAndTopStateModel(block, 0);
        BlockModelBuilder m1 = this.createSideAndTopStateModel(block, 1);
        this.addChargedMachineVariants(block, (ModelFile)m0, (ModelFile)m1);
    }

    private void addSidedOppositeMatchingFacesDeviceBlock(Block block) {
        BlockModelBuilder inactive = this.createOppositeMatchingFaceDeviceModel(block, false);
        BlockModelBuilder active = this.createOppositeMatchingFaceDeviceModel(block, true);
        this.addSidedDeviceVariants(block, (ModelFile)inactive, (ModelFile)active);
    }

    private void addTriStateSidedPoweredDeviceBlock(Block block) {
        BlockModelBuilder m0 = this.createSideStateModel(block, 0);
        BlockModelBuilder m1 = this.createSideStateModel(block, 1);
        BlockModelBuilder m2 = this.createSideStateModel(block, 2);
        this.addSidedPoweredDeviceVariants(block, (ModelFile)m0, (ModelFile)m1, (ModelFile)m1, (ModelFile)m2);
    }

    private void addSideAndTopActiveModel(Block block) {
        BlockModelBuilder inactive = this.createSideAndTopActiveModel(block, false);
        BlockModelBuilder active = this.createSideAndTopActiveModel(block, true);
        this.addSidedDeviceVariants(block, (ModelFile)inactive, (ModelFile)active);
    }

    private void addRotatableVariants(Block block, ModelFile model) {
        for (int r = 0; r < 4; ++r) {
            this.getVariantBuilder(block).partialState().with((Property)ProjectRedBlock.ROTATION, (Comparable)Integer.valueOf(r)).addModels(ConfiguredModel.builder().modelFile(model).rotationY(r * 90).build());
        }
    }

    private void addRotatablePoweredMachineVariants(Block block, ModelFile idle, ModelFile charged, ModelFile working, ModelFile chargedAndWorking) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int r = (Integer)state.m_61143_((Property)ProjectRedBlock.ROTATION);
            boolean isWorking = (Boolean)state.m_61143_((Property)ProjectRedBlock.WORKING);
            boolean isCharged = (Boolean)state.m_61143_((Property)ProjectRedBlock.CHARGED);
            ModelFile model = isWorking && isCharged ? chargedAndWorking : (isWorking ? working : (isCharged ? charged : idle));
            return ConfiguredModel.builder().modelFile(model).rotationY(r * 90).build();
        });
    }

    private void addChargedMachineVariants(Block block, ModelFile idle, ModelFile charged) {
        this.getVariantBuilder(block).forAllStates(state -> {
            boolean isCharged = (Boolean)state.m_61143_((Property)ProjectRedBlock.CHARGED);
            ModelFile model = isCharged ? charged : idle;
            return ConfiguredModel.builder().modelFile(model).build();
        });
    }

    private void addSidedDeviceVariants(Block block, ModelFile inactive, ModelFile active) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int s = (Integer)state.m_61143_((Property)ProjectRedBlock.SIDE);
            boolean isActive = (Boolean)state.m_61143_((Property)ProjectRedBlock.ACTIVE);
            return ConfiguredModel.builder().modelFile(isActive ? active : inactive).rotationX(DEVICE_SIDED_ROTATIONS[s][0] * 90).rotationY(DEVICE_SIDED_ROTATIONS[s][1] * 90).build();
        });
    }

    private void addSidedPoweredDeviceVariants(Block block, ModelFile idle, ModelFile charged, ModelFile working, ModelFile chargedAndWorking) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int s = (Integer)state.m_61143_((Property)ProjectRedBlock.SIDE);
            boolean isWorking = (Boolean)state.m_61143_((Property)ProjectRedBlock.WORKING);
            boolean isCharged = (Boolean)state.m_61143_((Property)ProjectRedBlock.CHARGED);
            ModelFile model = isWorking && isCharged ? chargedAndWorking : (isWorking ? working : (isCharged ? charged : idle));
            return ConfiguredModel.builder().modelFile(model).rotationX(DEVICE_SIDED_ROTATIONS[s][0] * 90).rotationY(DEVICE_SIDED_ROTATIONS[s][1] * 90).build();
        });
    }

    private BlockModelBuilder createOppositeMatchingFaceModel(Block block) {
        String texture = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        return (BlockModelBuilder)((BlockModelBuilder)this.models().cube(texture, this.modLoc("block/" + texture + "_bottom"), this.modLoc("block/" + texture + "_top"), this.modLoc("block/" + texture + "_front_back"), this.modLoc("block/" + texture + "_front_back"), this.modLoc("block/" + texture + "_left_right"), this.modLoc("block/" + texture + "_left_right"))).texture("particle", this.modLoc("block/" + texture + "_front_back"));
    }

    private BlockModelBuilder createBatteryModel(Block block, int charge) {
        String texture = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        String modelName = texture + (String)(charge > 0 ? "_charge" + charge : "");
        return (BlockModelBuilder)this.models().cubeBottomTop(modelName, this.modLoc("block/" + texture + "_side_" + charge), this.modLoc("block/" + texture + "_bottom"), this.modLoc("block/" + texture + "_top"));
    }

    private BlockModelBuilder createFrontFacedMachineModel(Block block, int state) {
        String texture = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        String modelName = texture + (String)(state > 0 ? "_state" + state : "");
        return (BlockModelBuilder)this.models().orientableWithBottom(modelName, this.modLoc("block/" + texture + "_side"), this.modLoc("block/" + texture + "_front_" + state), this.modLoc("block/" + texture + "_bottom"), this.modLoc("block/" + texture + "_top"));
    }

    private BlockModelBuilder createSideAndTopStateModel(Block block, int state) {
        String texture = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        String modelName = texture + (String)(state > 0 ? "_state" + state : "");
        return (BlockModelBuilder)this.models().cubeBottomTop(modelName, this.modLoc("block/" + texture + "_side_" + state), this.modLoc("block/" + texture + "_bottom"), this.modLoc("block/" + texture + "_top_" + state));
    }

    private BlockModelBuilder createSideStateModel(Block block, int state) {
        String texture = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        String modelName = texture + (String)(state > 0 ? "_state" + state : "");
        return (BlockModelBuilder)this.models().cubeBottomTop(modelName, this.modLoc("block/" + texture + "_side_" + state), this.modLoc("block/" + texture + "_bottom"), this.modLoc("block/" + texture + "_top"));
    }

    private BlockModelBuilder createSideAndTopActiveModel(Block block, boolean active) {
        String texture = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        String activeKey = active ? "_active" : "";
        String modelName = texture + activeKey;
        return (BlockModelBuilder)this.models().cubeBottomTop(modelName, this.modLoc("block/" + texture + "_side" + activeKey), this.modLoc("block/" + texture + "_bottom"), this.modLoc("block/" + texture + "_top" + activeKey));
    }

    private BlockModelBuilder createOppositeMatchingFaceDeviceModel(Block block, boolean active) {
        String texture = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        String activeKey = active ? "_active" : "";
        String modelName = texture + activeKey;
        return (BlockModelBuilder)((BlockModelBuilder)this.models().cube(modelName, this.modLoc("block/" + texture + "_bottom" + activeKey), this.modLoc("block/" + texture + "_top" + activeKey), this.modLoc("block/" + texture + "_front_back" + activeKey), this.modLoc("block/" + texture + "_front_back" + activeKey), this.modLoc("block/" + texture + "_left_right" + activeKey), this.modLoc("block/" + texture + "_left_right" + activeKey))).texture("particle", this.modLoc("block/" + texture + "_front_back" + activeKey));
    }
}

