/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.init;

import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.multipart.api.MultipartClientRegistry;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.part.render.PartRenderer;
import mrtjp.projectred.expansion.GraphDebugManager;
import mrtjp.projectred.expansion.MovementManager;
import mrtjp.projectred.expansion.TubeType;
import mrtjp.projectred.expansion.client.FrameBlockRenderer;
import mrtjp.projectred.expansion.client.FrameModelRenderer;
import mrtjp.projectred.expansion.client.FrameMotorBlockRenderer;
import mrtjp.projectred.expansion.client.FramePartRenderer;
import mrtjp.projectred.expansion.client.MovingBlockSuppressorRenderer;
import mrtjp.projectred.expansion.client.PneumaticSmokeParticle;
import mrtjp.projectred.expansion.client.TubePartRenderer;
import mrtjp.projectred.expansion.gui.screen.inventory.AutoCrafterScreen;
import mrtjp.projectred.expansion.gui.screen.inventory.BatteryBoxScreen;
import mrtjp.projectred.expansion.gui.screen.inventory.ChargingBenchScreen;
import mrtjp.projectred.expansion.gui.screen.inventory.DeployerScreen;
import mrtjp.projectred.expansion.gui.screen.inventory.ProjectBenchScreen;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.init.ExpansionItems;
import mrtjp.projectred.expansion.init.ExpansionMenus;
import mrtjp.projectred.expansion.init.ExpansionParts;
import mrtjp.projectred.expansion.item.RecipePlanItem;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ExpansionClientInit {
    public static final ResourceLocation ITEM_MODEL_PROPERTY_CHARGE_LEVEL = new ResourceLocation("projectred_expansion", "charge_level");
    public static final ResourceLocation ITEM_MODEL_PROPERTY_WRITTEN_RECIPE_PLAN = new ResourceLocation("projectred_expansion", "written");

    public static void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(ExpansionClientInit::clientSetup);
        MinecraftForge.EVENT_BUS.addListener(MovementManager::onRenderLevelStage);
        MinecraftForge.EVENT_BUS.addListener(GraphDebugManager::onRenderLevelStage);
        modEventBus.addListener(FrameModelRenderer::onTextureStitchEvent);
        modEventBus.addListener(FrameMotorBlockRenderer::onTextureStitchEvent);
        modEventBus.addListener(PneumaticSmokeParticle::onTextureStitchEvent);
        for (TubeType type : TubeType.values()) {
            modEventBus.addListener(type::onTextureStitchEvent);
        }
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)ExpansionMenus.PROJECT_BENCH_MENU.get()), ProjectBenchScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ExpansionMenus.BATTERY_BOX_MENU.get()), BatteryBoxScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ExpansionMenus.AUTO_CRAFTER_MENU.get()), AutoCrafterScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ExpansionMenus.CHARGING_BENCH_MENU.get()), ChargingBenchScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ExpansionMenus.DEPLOYER_MENU.get()), DeployerScreen::new);
        ExpansionClientInit.addItemModelProperties();
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ExpansionBlocks.FRAME_BLOCK.get()), (RenderType)RenderType.m_110463_());
        BlockRenderingRegistry.registerRenderer((Block)((Block)ExpansionBlocks.FRAME_BLOCK.get()), (ICCBlockRenderer)FrameBlockRenderer.INSTANCE);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ExpansionBlocks.FRAME_MOTOR_BLOCK.get()), (RenderType)RenderType.m_110451_());
        BlockRenderingRegistry.registerRenderer((Block)((Block)ExpansionBlocks.FRAME_MOTOR_BLOCK.get()), (ICCBlockRenderer)FrameMotorBlockRenderer.INSTANCE);
        BlockRenderingRegistry.registerGlobalRenderer((ICCBlockRenderer)MovingBlockSuppressorRenderer.INSTANCE);
        MultipartClientRegistry.register((MultipartType)((MultipartType)ExpansionParts.FRAME_PART.get()), FramePartRenderer.INSTANCE);
        for (TubeType type : TubeType.values()) {
            MultipartClientRegistry.register(type.getPartType(), (PartRenderer)((PartRenderer)SneakyUtils.unsafeCast((Object)TubePartRenderer.INSTANCE)));
        }
    }

    private static void addItemModelProperties() {
        ItemProperties.register((Item)((Block)ExpansionBlocks.BATTERY_BOX_BLOCK.get()).m_5456_(), (ResourceLocation)ITEM_MODEL_PROPERTY_CHARGE_LEVEL, (stack, world, entity, seed) -> {
            if (stack.m_41782_()) {
                return stack.m_41783_().m_128451_("charge_level");
            }
            return 0.0f;
        });
        ItemProperties.register((Item)((Item)ExpansionItems.RECIPE_PLAN_ITEM.get()), (ResourceLocation)ITEM_MODEL_PROPERTY_WRITTEN_RECIPE_PLAN, (stack, world, entity, seed) -> RecipePlanItem.hasRecipeInside(stack) ? 1.0f : 0.0f);
    }
}

