/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Vector3;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mrtjp.projectred.core.inventory.BaseContainer;
import mrtjp.projectred.expansion.CraftingHelper;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.inventory.container.AutoCrafterMenu;
import mrtjp.projectred.expansion.item.RecipePlanItem;
import mrtjp.projectred.expansion.tile.BaseMachineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class AutoCrafterBlockEntity
extends BaseMachineBlockEntity
implements CraftingHelper.InventorySource {
    private static final int KEY_CYCLE_PLAN = 2;
    private final BaseContainer planInventory = new BaseContainer(9){

        public boolean m_7013_(int slot, ItemStack stack) {
            return RecipePlanItem.hasRecipeInside(stack);
        }
    };
    private final BaseContainer storageInventory = new BaseContainer(18);
    private final BaseContainer craftingGrid = new BaseContainer(9);
    private final LazyOptional<? extends IItemHandler> handler = LazyOptional.of(() -> new InvWrapper((Container)this.storageInventory));
    private final CraftingHelper craftingHelper = new CraftingHelper(this);
    private boolean recipeNeedsUpdate = true;
    private int planSlot = 0;
    private int idleTicksOnPlan = 0;

    public AutoCrafterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExpansionBlocks.AUTO_CRAFTER_BLOCK_ENTITY.get(), pos, state);
        this.planInventory.m_19164_(this::onInventoryChanged);
        this.storageInventory.m_19164_(this::onInventoryChanged);
    }

    @Override
    public void saveToNBT(CompoundTag tag) {
        super.saveToNBT(tag);
        this.storageInventory.saveTo(tag, "storage_inv");
        this.planInventory.saveTo(tag, "plan_inv");
        tag.m_128344_("plan_slot", (byte)this.planSlot);
    }

    @Override
    public void loadFromNBT(CompoundTag tag) {
        super.loadFromNBT(tag);
        this.storageInventory.loadFrom(tag, "storage_inv");
        this.planInventory.loadFrom(tag, "plan_inv");
        this.planSlot = tag.m_128445_("plan_slot") & 0xFF;
    }

    public void writeDesc(MCDataOutput out) {
        super.writeDesc(out);
    }

    public void readDesc(MCDataInput in) {
        super.readDesc(in);
    }

    public void receiveUpdateFromServer(int key, MCDataInput input) {
        super.receiveUpdateFromServer(key, input);
    }

    public void receiveUpdateFromClient(int key, MCDataInput input, ServerPlayer player) {
        switch (key) {
            case 2: {
                this.cyclePlan();
                break;
            }
            default: {
                super.receiveUpdateFromClient(key, input, player);
            }
        }
    }

    public void sendCyclePlan() {
        this.sendUpdateToServer(2, p -> {});
    }

    @Override
    protected AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new AutoCrafterMenu(playerInventory, this, windowId);
    }

    public void onBlockRemoved() {
        super.onBlockRemoved();
        Vector3 pos = Vector3.fromTileCenter((BlockEntity)this);
        AutoCrafterBlockEntity.dropInventory((Container)this.planInventory, (Level)this.m_58904_(), (Vector3)pos);
        AutoCrafterBlockEntity.dropInventory((Container)this.storageInventory, (Level)this.m_58904_(), (Vector3)pos);
    }

    private void onInventoryChanged(Container inventory) {
        this.recipeNeedsUpdate = true;
        this.m_6596_();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (this.idleTicksOnPlan > this.getMaxPlanIdleTicks()) {
            this.cyclePlan();
        }
        this.updateRecipeIfNeeded();
    }

    public void updateRecipeIfNeeded() {
        if (this.recipeNeedsUpdate) {
            this.recipeNeedsUpdate = false;
            ItemStack plan = this.planInventory.m_8020_(this.planSlot);
            if (RecipePlanItem.hasRecipeInside(plan)) {
                RecipePlanItem.loadPlanInputsToGrid((Container)this.craftingGrid, plan);
            } else {
                this.craftingGrid.m_6211_();
            }
            this.craftingHelper.onInventoryChanged();
        }
    }

    private void cyclePlan() {
        int start = this.planSlot;
        do {
            this.planSlot = (this.planSlot + 1) % 9;
        } while (this.planSlot != start && this.planInventory.m_8020_(this.planSlot).m_41619_());
        if (this.planSlot != start) {
            this.recipeNeedsUpdate = true;
            this.idleTicksOnPlan = 0;
        }
    }

    private int getMaxPlanIdleTicks() {
        return 10;
    }

    @Override
    public Container getCraftingMatrix() {
        return this.craftingGrid;
    }

    @Override
    public Container getStorage() {
        return this.storageInventory;
    }

    @Override
    public Level getWorld() {
        return this.m_58904_();
    }

    public SimpleContainer getPlanInventory() {
        return this.planInventory;
    }

    public SimpleContainer getStorageInventory() {
        return this.storageInventory;
    }

    public int getPlanSlot() {
        return this.planSlot;
    }

    @Override
    protected boolean canStartOrContinueWork() {
        this.updateRecipeIfNeeded();
        boolean canTake = this.craftingHelper.canTakeIntoStorage();
        if (!canTake) {
            ++this.idleTicksOnPlan;
        }
        return canTake;
    }

    @Override
    protected int startWork() {
        return 100;
    }

    @Override
    protected int tickWork(int remainingWork) {
        this.updateRecipeIfNeeded();
        if (this.canConductorWork() && this.craftingHelper.canTakeIntoStorage()) {
            this.conductor.applyPower(-1100.0);
            return 1;
        }
        return 0;
    }

    @Override
    protected void finishWork() {
        this.updateRecipeIfNeeded();
        this.craftingHelper.onCraftedIntoStorage();
        this.cyclePlan();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.handler.invalidate();
    }
}

