/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import codechicken.lib.util.ServerUtils;
import mrtjp.projectred.api.IScrewdriver;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.expansion.tile.LowLoadPoweredBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class BaseMachineBlockEntity
extends LowLoadPoweredBlockEntity {
    private boolean isWorking = false;
    private boolean isCharged = false;
    private int remainingWork = 0;
    private int totalWork = 0;

    public BaseMachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void saveToNBT(CompoundTag tag) {
        super.saveToNBT(tag);
        tag.m_128405_("remaining_work", this.remainingWork);
        tag.m_128405_("total_work", this.totalWork);
        tag.m_128379_("working", this.isWorking);
        tag.m_128379_("charging", this.isCharged);
    }

    @Override
    public void loadFromNBT(CompoundTag tag) {
        super.loadFromNBT(tag);
        this.remainingWork = tag.m_128451_("remaining_work");
        this.totalWork = tag.m_128451_("total_work");
        this.isWorking = tag.m_128471_("working");
        this.isCharged = tag.m_128471_("charging");
    }

    public BlockState storeBlockState(BlockState defaultState) {
        return (BlockState)((BlockState)super.storeBlockState(defaultState).m_61124_((Property)ProjectRedBlock.CHARGED, (Comparable)Boolean.valueOf(this.isCharged))).m_61124_((Property)ProjectRedBlock.WORKING, (Comparable)Boolean.valueOf(this.isWorking));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.m_58904_().f_46443_) {
            return;
        }
        this.isCharged = this.canConductorWork();
        if (!this.isWorking && this.canStartOrContinueWork()) {
            this.isWorking = true;
            this.remainingWork = this.totalWork = this.startWork();
        }
        if (!this.canStartOrContinueWork()) {
            this.isWorking = false;
            this.remainingWork = 0;
            this.totalWork = 0;
        } else {
            int workDone = this.tickWork(this.remainingWork);
            this.remainingWork -= workDone;
            if (this.remainingWork <= 0) {
                this.isWorking = false;
                this.remainingWork = 0;
                this.totalWork = 0;
                this.finishWork();
            }
        }
        BlockState state = this.m_58900_();
        if (this.isCharged != (Boolean)state.m_61143_((Property)ProjectRedBlock.CHARGED) || this.isWorking != (Boolean)state.m_61143_((Property)ProjectRedBlock.WORKING)) {
            this.pushBlockState();
        }
    }

    public InteractionResult onBlockActivated(Player player, InteractionHand hand, BlockHitResult hit) {
        IScrewdriver screwdriver;
        ItemStack held = player.m_21120_(hand);
        Item item = held.m_41720_();
        if (item instanceof IScrewdriver && (screwdriver = (IScrewdriver)item).canUse(player, held)) {
            if (!this.f_58857_.f_46443_) {
                this.rotateBlock();
                screwdriver.damageScrewdriver(player, held);
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
        }
        if (!this.f_58857_.f_46443_) {
            this.openGui(player);
        }
        return InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
    }

    private void rotateBlock() {
        BlockState state = this.m_58904_().m_8055_(this.m_58899_());
        int r = (Integer)state.m_61143_((Property)ProjectRedBlock.ROTATION);
        int newRotation = (r + 1) % 4;
        this.m_58904_().m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)ProjectRedBlock.ROTATION, (Comparable)Integer.valueOf(newRotation)));
    }

    private void openGui(Player player) {
        ServerUtils.openContainer((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider(this::createMenu, (Component)this.m_58900_().m_60734_().m_49954_()), p -> p.writePos(this.m_58899_()));
    }

    protected abstract AbstractContainerMenu createMenu(int var1, Inventory var2, Player var3);

    public int getRemainingWork() {
        return this.remainingWork;
    }

    public int getTotalWork() {
        return this.totalWork;
    }

    protected abstract boolean canStartOrContinueWork();

    protected abstract int startWork();

    protected abstract int tickWork(int var1);

    protected abstract void finishWork();
}

