/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import codechicken.lib.util.ServerUtils;
import codechicken.lib.vec.Vector3;
import com.mojang.authlib.GameProfile;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mrtjp.projectred.core.inventory.BaseContainer;
import mrtjp.projectred.expansion.ProjectRedExpansion;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.inventory.container.DeployerMenu;
import mrtjp.projectred.expansion.tile.BaseDeviceBlockEntity;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class DeployerBlockEntity
extends BaseDeviceBlockEntity {
    private static final GameProfile PR_FAKE_PLAYER = new GameProfile(UUID.fromString("6140461b-e5b4-41ba-beb1-dce616e6abc0"), "[ProjectRed]");
    private final BaseContainer inventory = new BaseContainer(9);
    private final LazyOptional<? extends IItemHandler> handler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));

    public DeployerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExpansionBlocks.DEPLOYER_BLOCK_ENTITY.get(), pos, state);
        this.inventory.m_19164_(c -> this.m_6596_());
    }

    @Override
    public void saveToNBT(CompoundTag tag) {
        super.saveToNBT(tag);
        this.inventory.saveTo(tag, "inventory");
    }

    @Override
    public void loadFromNBT(CompoundTag tag) {
        super.loadFromNBT(tag);
        this.inventory.loadFrom(tag, "inventory");
    }

    public void onBlockRemoved() {
        super.onBlockRemoved();
        DeployerBlockEntity.dropInventory((Container)this.inventory, (Level)this.m_58904_(), (Vector3)Vector3.fromBlockPos((BlockPos)this.m_58899_()));
    }

    @Override
    public InteractionResult onBlockActivated(Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.m_58904_().f_46443_) {
            ServerUtils.openContainer((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new DeployerMenu(inv, this, id), (Component)this.m_58900_().m_60734_().m_49954_()), p -> p.writePos(this.m_58899_()));
        }
        return InteractionResult.m_19078_((boolean)this.m_58904_().f_46443_);
    }

    @Override
    protected void onActivated() {
        FakePlayer player = FakePlayerFactory.get((ServerLevel)((ServerLevel)this.m_58904_()), (GameProfile)PR_FAKE_PLAYER);
        player.m_150109_().m_6211_();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            player.m_150109_().m_6836_(i, this.inventory.m_8020_(i));
        }
        boolean success = this.deployFromFakePlayer((Player)player);
        if (success) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                this.inventory.m_6836_(i, player.m_150109_().m_8020_(i));
            }
            LinkedList<ItemStack> remaining = new LinkedList<ItemStack>();
            for (int i = this.inventory.m_6643_(); i < player.m_150109_().m_6643_(); ++i) {
                ItemStack rem = this.inventory.m_19173_(player.m_150109_().m_8020_(i));
                if (rem.m_41619_()) continue;
                remaining.add(rem);
            }
            if (!remaining.isEmpty()) {
                this.handlePostDeployExcess(remaining);
            }
        }
    }

    @Override
    protected void onDeactivated() {
    }

    protected boolean deployFromFakePlayer(Player player) {
        Direction useDir = Direction.values()[this.side ^ 1];
        BlockPos usePos = this.m_58899_().m_121945_(useDir);
        Vec3 hitTarget = new Vec3((double)usePos.m_123341_() + 0.5, (double)usePos.m_123342_() + 0.5, (double)usePos.m_123343_() + 0.5);
        BlockHitResult hit = new BlockHitResult(hitTarget, Direction.values()[this.side], usePos, false);
        player.m_6034_((double)this.m_58899_().m_123341_() + 0.5 + (double)useDir.m_122429_() * 0.9, (double)this.m_58899_().m_123342_() + 0.5 + (double)useDir.m_122430_() * 0.9 - (double)player.m_20192_(), (double)this.m_58899_().m_123343_() + 0.5 + (double)useDir.m_122431_() * 0.9);
        player.m_7618_(EntityAnchorArgument.Anchor.EYES, hitTarget);
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_()) continue;
            ItemStack mainHand = player.m_21205_();
            player.m_8061_(EquipmentSlot.MAINHAND, stack);
            player.m_150109_().m_6836_(i, mainHand);
            InteractionResult result = this.runInteractWithEntityLogic(player, usePos, hit);
            if (!result.m_19077_()) {
                result = this.runUseOnLogic(player, usePos, hit);
            }
            ItemStack slotStack = player.m_150109_().m_8020_(i);
            player.m_150109_().m_6836_(i, player.m_21205_());
            player.m_8061_(EquipmentSlot.MAINHAND, slotStack);
            if (!result.m_19077_()) continue;
            return true;
        }
        return false;
    }

    protected InteractionResult runUseOnLogic(Player player, BlockPos usePos, BlockHitResult hit) {
        InteractionResult result;
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((Player)player, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)usePos, (BlockHitResult)hit);
        if (event.isCanceled()) {
            return event.getCancellationResult();
        }
        UseOnContext ctx = new UseOnContext(player, InteractionHand.MAIN_HAND, hit);
        if (event.getUseItem() != Event.Result.DENY && (result = player.m_21205_().onItemUseFirst(ctx)).m_19077_()) {
            return result;
        }
        if (event.getUseBlock() != Event.Result.DENY && (result = this.m_58904_().m_8055_(usePos).m_60664_(this.m_58904_(), player, InteractionHand.MAIN_HAND, hit)).m_19077_()) {
            return result;
        }
        if (event.getUseItem() == Event.Result.DENY) {
            return InteractionResult.PASS;
        }
        result = player.m_21205_().m_41661_(ctx);
        if (result.m_19077_()) {
            return result;
        }
        result = ForgeHooks.onItemRightClick((Player)player, (InteractionHand)InteractionHand.MAIN_HAND);
        if (result != null) {
            return result;
        }
        player.f_20935_ = ItemStack.f_41583_;
        player.f_20936_ = 0;
        InteractionResultHolder resultHolder = player.m_21205_().m_41682_(this.m_58904_(), player, InteractionHand.MAIN_HAND);
        if (resultHolder.m_19089_().m_19077_()) {
            player.m_21008_(InteractionHand.MAIN_HAND, (ItemStack)resultHolder.m_19095_());
            if (!player.f_20935_.m_41619_()) {
                player.f_20936_ = 0;
                player.m_21253_();
            }
            return resultHolder.m_19089_();
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult runInteractWithEntityLogic(Player player, BlockPos usePos, BlockHitResult hit) {
        List entities = this.m_58904_().m_45933_((Entity)player, new AABB(usePos));
        for (Entity entity : entities) {
            InteractionResult result = player.m_36157_(entity, InteractionHand.MAIN_HAND);
            if (result.m_19077_()) {
                return result;
            }
            Vec3 vec3 = hit.m_82450_().m_82492_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            result = ForgeHooks.onInteractEntityAt((Player)player, (Entity)entity, (Vec3)vec3, (InteractionHand)InteractionHand.MAIN_HAND);
            if (result != null) {
                return result;
            }
            result = entity.m_7111_(player, vec3, InteractionHand.MAIN_HAND);
            if (!result.m_19077_()) continue;
            return result;
        }
        return InteractionResult.PASS;
    }

    protected void handlePostDeployExcess(List<ItemStack> excess) {
        ProjectRedExpansion.LOGGER.warn("Deployer at {} has excess items: {}", (Object)this.m_58899_(), excess);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER && side != Direction.values()[this.side ^ 1]) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.handler.invalidate();
    }

    public BaseContainer getInventory() {
        return this.inventory;
    }
}

