/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.network.message;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class SyncedEffectMessage {
    private final BlockPos pos;
    private final Type type;

    public SyncedEffectMessage(BlockPos pos, Type type) {
        this.pos = pos;
        this.type = type;
    }

    public static void encode(SyncedEffectMessage message, FriendlyByteBuf buf) {
        buf.writeLong(message.pos.m_121878_());
        buf.writeByte(message.type.ordinal());
    }

    public static SyncedEffectMessage decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        Type type = Type.values()[buf.readByte()];
        return new SyncedEffectMessage(pos, type);
    }

    public static void handle(Player player, SyncedEffectMessage message) {
        SimpleParticleType particleType = ParticleTypes.f_123813_;
        int particleCount = 1;
        float particleRandomOffset = 1.0f;
        Vec3i particleOffset = Vec3i.f_123288_;
        SoundEvent soundEvent = null;
        float volume = 1.0f;
        switch (message.type) {
            case COW_IN_A_JAR: {
                soundEvent = SoundEvents.f_11752_;
                particleOffset = new Vec3i(0, 1, 0);
                break;
            }
            case OVEN_UPGRADE: 
            case FRIDGE_UPGRADE: 
            case KITCHEN_UPGRADE: {
                soundEvent = SoundEvents.f_11671_;
                particleType = ParticleTypes.f_123755_;
                particleCount = 10;
                volume = 0.5f;
            }
        }
        if (soundEvent != null) {
            Minecraft.m_91087_().f_91073_.m_7785_((double)message.pos.m_123341_(), (double)message.pos.m_123342_(), (double)message.pos.m_123343_(), soundEvent, SoundSource.BLOCKS, volume, 1.0f, false);
        }
        for (int i = 0; i < particleCount; ++i) {
            float offsetX = (float)particleOffset.m_123341_() + 0.5f + (float)(Math.random() - 0.5) * particleRandomOffset;
            float offsetY = (float)particleOffset.m_123341_() + 0.5f + (float)(Math.random() - 0.5) * particleRandomOffset;
            float offsetZ = (float)particleOffset.m_123341_() + 0.5f + (float)(Math.random() - 0.5) * particleRandomOffset;
            Minecraft.m_91087_().f_91073_.m_6493_((ParticleOptions)particleType, true, (double)((float)message.pos.m_123341_() + offsetX), (double)((float)message.pos.m_123342_() + offsetY), (double)((float)message.pos.m_123343_() + offsetZ), 0.0, 0.0, 0.0);
        }
    }

    public static enum Type {
        COW_IN_A_JAR,
        OVEN_UPGRADE,
        FRIDGE_UPGRADE,
        KITCHEN_UPGRADE;

    }
}

