/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.distant_signals;

import com.railwayteam.railways.content.distant_signals.IOverridableSignal;
import com.railwayteam.railways.content.semaphore.SemaphoreBlockEntity;
import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.NixieTubeDisplaySource;
import com.simibubi.create.content.redstone.displayLink.source.SingleLineDisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.simibubi.create.content.trains.signal.SignalBlockEntity;
import java.util.Locale;
import java.util.Optional;
import net.createmod.catnip.data.Pair;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SignalDisplaySource
extends SingleLineDisplaySource {
    protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        SignalBlockEntity.SignalState state = SignalBlockEntity.SignalState.INVALID;
        BlockEntity blockEntity = context.getSourceBlockEntity();
        if (blockEntity instanceof SignalBlockEntity) {
            SignalBlockEntity signalBE = (SignalBlockEntity)blockEntity;
            state = signalBE.getState();
        }
        if (SignalDisplaySource.isSignalTarget(context)) {
            return Component.m_237113_((String)state.name());
        }
        return Component.m_237115_((String)("railways.display_source.signal." + state.name().toLowerCase(Locale.ROOT)));
    }

    protected boolean allowsLabeling(DisplayLinkContext context) {
        return !SignalDisplaySource.isSignalTarget(context);
    }

    public static boolean isSignalTarget(DisplayLinkContext context) {
        return context.getTargetBlockEntity() instanceof NixieTubeBlockEntity || context.getTargetBlockEntity() instanceof SemaphoreBlockEntity;
    }

    public void updateState(DisplayLinkBlockEntity be) {
        be.updateGatheredData();
    }

    public int getPassiveRefreshTicks() {
        return 40;
    }

    public static boolean hasSignalSource(DisplayLinkContext context) {
        if (context.getSourceBlockEntity() instanceof SignalBlockEntity) {
            return true;
        }
        BlockEntity blockEntity = context.getSourceBlockEntity();
        if (blockEntity instanceof NixieTubeBlockEntity) {
            BlockEntity blockEntity2;
            NixieTubeBlockEntity nixie = (NixieTubeBlockEntity)blockEntity;
            DisplaySource source = context.blockEntity().activeSource;
            if (source instanceof SignalDisplaySource) {
                return true;
            }
            if (source instanceof NixieTubeDisplaySource && (blockEntity2 = context.getSourceBlockEntity()) instanceof NixieTubeBlockEntity) {
                NixieTubeBlockEntity nixieSource = (NixieTubeBlockEntity)blockEntity2;
                if (((IOverridableSignal)nixieSource).railways$getOverriddenState().isPresent()) {
                    return true;
                }
                if (SignalDisplaySource.getState(nixie.getFullText()).isPresent()) {
                    return true;
                }
            }
        }
        return false;
    }

    public static Pair<SignalBlockEntity.SignalState, Optional<SignalBlockEntity>> getSignalState(DisplayLinkContext context, MutableComponent text) {
        BlockEntity blockEntity = context.getSourceBlockEntity();
        if (blockEntity instanceof SignalBlockEntity) {
            SignalBlockEntity signalBE = (SignalBlockEntity)blockEntity;
            return Pair.of((Object)signalBE.getState(), Optional.of(signalBE));
        }
        String name = text.getString();
        return Pair.of((Object)SignalDisplaySource.getState(text).orElse(SignalBlockEntity.SignalState.INVALID), Optional.empty());
    }

    public static Optional<SignalBlockEntity.SignalState> getState(MutableComponent text) {
        String name = text.getString();
        try {
            return Optional.of(SignalBlockEntity.SignalState.valueOf((String)name));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }
}

