/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util;

import com.railwayteam.railways.util.forge.RegistrationListeningImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public class RegistrationListening {
    public static <T> void whenRegistered(Registry<T> registry, ResourceLocation id, Consumer<T> consumer) {
        RegistrationListening.addListener(new Listener<T>(registry, id, consumer));
    }

    public static <T> void whenBothRegistered(Registry<T> registry, ResourceLocation id1, ResourceLocation id2, BiConsumer<T, T> consumer) {
        RegistrationListening.whenBothRegistered(registry, id1, registry, id2, consumer);
    }

    public static <T, U> void whenBothRegistered(Registry<T> registry1, ResourceLocation id1, Registry<U> registry2, ResourceLocation id2, BiConsumer<T, U> consumer) {
        DualListener<T, U> dual = new DualListener<T, U>(registry1, id1, registry2, id2, consumer);
        RegistrationListening.addListener(dual.listener1);
        RegistrationListening.addListener(dual.listener2);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> void addListener(Listener<T> listener) {
        RegistrationListeningImpl.addListener(listener);
    }

    public record Listener<T>(Registry<T> registry, ResourceLocation id, Consumer<T> consumer) {
        public void onRegister(T obj) {
            this.consumer.accept(obj);
        }
    }

    public static class DualListener<T, U> {
        public final Listener<T> listener1;
        public final Listener<U> listener2;
        private final BiConsumer<T, U> consumer;
        private T first;
        private U second;

        public DualListener(Registry<T> registry1, ResourceLocation id1, Registry<U> registry2, ResourceLocation id2, BiConsumer<T, U> consumer) {
            this.consumer = consumer;
            this.listener1 = new Listener<Object>(registry1, id1, this::firstRegistered);
            this.listener2 = new Listener<Object>(registry2, id2, this::secondRegistered);
        }

        private void firstRegistered(T first) {
            this.first = first;
            if (this.second != null) {
                this.bothRegistered();
            }
        }

        private void secondRegistered(U second) {
            this.second = second;
            if (this.first != null) {
                this.bothRegistered();
            }
        }

        private void bothRegistered() {
            this.consumer.accept(this.first, this.second);
        }
    }
}

