/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.init.ModBlocks;
import com.tacz.guns.particles.BulletHoleOption;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BulletHoleParticle
extends TextureSheetParticle {
    private final Direction direction;
    private final BlockPos pos;
    private int uOffset;
    private int vOffset;
    private float textureDensity;

    public BulletHoleParticle(ClientLevel world, double x, double y, double z, Direction direction, BlockPos pos, String ammoId, String gunId, String gunDisplayId) {
        super(world, x, y, z);
        this.m_108337_(this.getSprite(pos));
        this.direction = direction;
        this.pos = pos;
        this.f_107225_ = this.getLifetimeFromConfig(world);
        this.f_107219_ = false;
        this.f_107226_ = 0.0f;
        this.f_107663_ = 0.05f;
        BlockState state = world.m_8055_(pos);
        if (state.m_60713_((Block)ModBlocks.TARGET.get()) || this.shouldRemove()) {
            this.m_107274_();
        }
        TimelessAPI.getGunDisplay(new ResourceLocation(gunDisplayId), new ResourceLocation(gunId)).ifPresent(gunIndex -> {
            float[] gunTracerColor = gunIndex.getTracerColor();
            if (gunTracerColor != null) {
                this.f_107227_ = gunTracerColor[0];
                this.f_107228_ = gunTracerColor[1];
                this.f_107229_ = gunTracerColor[2];
            } else {
                TimelessAPI.getClientAmmoIndex(new ResourceLocation(ammoId)).ifPresent(ammoIndex -> {
                    float[] ammoTracerColor = ammoIndex.getTracerColor();
                    this.f_107227_ = ammoTracerColor[0];
                    this.f_107228_ = ammoTracerColor[1];
                    this.f_107229_ = ammoTracerColor[2];
                });
            }
        });
        this.f_107230_ = 0.9f;
    }

    private int getLifetimeFromConfig(ClientLevel world) {
        int configLife = (Integer)RenderConfig.BULLET_HOLE_PARTICLE_LIFE.get();
        if (configLife <= 1) {
            return configLife;
        }
        return configLife + world.f_46441_.m_188503_(configLife / 2);
    }

    protected void m_108337_(TextureAtlasSprite sprite) {
        super.m_108337_(sprite);
        this.uOffset = this.f_107223_.m_188503_(16);
        this.vOffset = this.f_107223_.m_188503_(16);
        this.textureDensity = (sprite.m_118410_() - sprite.m_118409_()) / 16.0f;
    }

    private TextureAtlasSprite getSprite(BlockPos pos) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel world = minecraft.f_91073_;
        if (world != null) {
            BlockState state = world.m_8055_(pos);
            return Minecraft.m_91087_().m_91289_().m_110907_().getTexture(state, (Level)world, pos);
        }
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(MissingTextureAtlasSprite.m_118071_());
    }

    protected float m_5970_() {
        return this.f_108321_.m_118409_() + (float)this.uOffset * this.textureDensity;
    }

    protected float m_5951_() {
        return this.f_108321_.m_118411_() + (float)this.vOffset * this.textureDensity;
    }

    protected float m_5952_() {
        return this.m_5970_() + this.textureDensity;
    }

    protected float m_5950_() {
        return this.m_5951_() + this.textureDensity;
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.shouldRemove()) {
            this.m_107274_();
        }
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Vec3 view = renderInfo.m_90583_();
        float particleX = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - view.m_7096_());
        float particleY = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - view.m_7098_());
        float particleZ = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - view.m_7094_());
        Quaternionf quaternion = this.direction.m_253075_();
        Vector3f[] points = new Vector3f[]{new Vector3f(-1.0f, 0.01f, -1.0f), new Vector3f(-1.0f, 0.01f, 1.0f), new Vector3f(1.0f, 0.01f, 1.0f), new Vector3f(1.0f, 0.01f, -1.0f)};
        float scale = this.m_5902_(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = points[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(scale);
            vector3f.add(particleX, particleY, particleZ);
        }
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        int light = Math.max(15 - this.f_107224_ / 2, 0);
        int lightColor = LightTexture.m_109885_((int)light, (int)light);
        float colorPercent = (float)light / 15.0f;
        float red = this.f_107227_ * colorPercent;
        float green = this.f_107228_ * colorPercent;
        float blue = this.f_107229_ * colorPercent;
        double threshold = (Double)RenderConfig.BULLET_HOLE_PARTICLE_FADE_THRESHOLD.get() * (double)this.f_107225_;
        float fade = 1.0f - (float)(Math.max((double)this.f_107224_ - threshold, 0.0) / ((double)this.f_107225_ - threshold));
        float alphaFade = this.f_107230_ * fade;
        buffer.m_5483_((double)points[0].x(), (double)points[0].y(), (double)points[0].z()).m_7421_(u1, v1).m_85950_(red, green, blue, alphaFade).m_85969_(lightColor).m_5752_();
        buffer.m_5483_((double)points[1].x(), (double)points[1].y(), (double)points[1].z()).m_7421_(u1, v0).m_85950_(red, green, blue, alphaFade).m_85969_(lightColor).m_5752_();
        buffer.m_5483_((double)points[2].x(), (double)points[2].y(), (double)points[2].z()).m_7421_(u0, v0).m_85950_(red, green, blue, alphaFade).m_85969_(lightColor).m_5752_();
        buffer.m_5483_((double)points[3].x(), (double)points[3].y(), (double)points[3].z()).m_7421_(u0, v1).m_85950_(red, green, blue, alphaFade).m_85969_(lightColor).m_5752_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107429_;
    }

    private boolean shouldRemove() {
        BlockState blockState = this.f_107208_.m_8055_(this.pos);
        if (blockState.m_60795_()) {
            return true;
        }
        VoxelShape shape = blockState.m_60812_((BlockGetter)this.f_107208_, this.pos);
        if (shape.m_83281_()) {
            return true;
        }
        AABB baseBlockBoundingBox = shape.m_83215_();
        AABB blockBoundingBox = baseBlockBoundingBox.m_82338_(this.pos);
        boolean intersects = blockBoundingBox.m_82314_(this.f_107212_ - 0.1, this.f_107213_ - 0.1, this.f_107214_ - 0.1, this.f_107212_ + 0.1, this.f_107213_ + 0.1, this.f_107214_ + 0.1);
        return !intersects;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<BulletHoleOption> {
        public BulletHoleParticle createParticle(@NotNull BulletHoleOption option, @NotNull ClientLevel world, double x, double y, double z, double pXSpeed, double pYSpeed, double pZSpeed) {
            BulletHoleParticle particle = new BulletHoleParticle(world, x, y, z, option.getDirection(), option.getPos(), option.getAmmoId(), option.getGunId(), option.getGunDisplayId());
            return particle;
        }
    }
}

