/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.network.message;

import com.tacz.guns.inventory.GunSmithTableMenu;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class ClientMessageCraft {
    private final ResourceLocation recipeId;
    private final int menuId;

    public ClientMessageCraft(ResourceLocation recipeId, int menuId) {
        this.recipeId = recipeId;
        this.menuId = menuId;
    }

    public static void encode(ClientMessageCraft message, FriendlyByteBuf buf) {
        buf.m_130085_(message.recipeId);
        buf.m_130130_(message.menuId);
    }

    public static ClientMessageCraft decode(FriendlyByteBuf buf) {
        return new ClientMessageCraft(buf.m_130281_(), buf.m_130242_());
    }

    public static void handle(ClientMessageCraft message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                AbstractContainerMenu patt1464$temp;
                ServerPlayer entity = context.getSender();
                if (entity == null) {
                    return;
                }
                if (entity.f_36096_.f_38840_ == message.menuId && (patt1464$temp = entity.f_36096_) instanceof GunSmithTableMenu) {
                    GunSmithTableMenu menu = (GunSmithTableMenu)patt1464$temp;
                    menu.doCraft(message.recipeId, (Player)entity);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

