/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunk;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.internal.InternalAPI;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.compat.flywheel.FlywheelCompat;
import xfacthd.framedblocks.common.compat.starlight.StarlightCompat;

public final class InternalApiImpl
implements InternalAPI {
    @Override
    @Nullable
    public BlockEntity getExistingBlockEntity(BlockGetter level, BlockPos pos) {
        if (FlywheelCompat.isVirtualLevel(level)) {
            return level.m_7702_(pos);
        }
        return InternalApiImpl.getExistingBlockEntity0(level, pos);
    }

    @Override
    public BlockEntity getBlockEntityForLight(BlockGetter level, BlockPos pos) {
        return StarlightCompat.getBlockEntityForLight(level, pos);
    }

    @Override
    public void updateCamoNbt(CompoundTag tag, String stateKey, String stackKey, String camoKey) {
        if (tag.m_128441_(stateKey)) {
            CompoundTag stateTag = tag.m_128469_(stateKey);
            tag.m_128473_(stateKey);
            tag.m_128473_(stackKey);
            CompoundTag camoTag = new CompoundTag();
            camoTag.m_128359_("type", FBContent.FACTORY_BLOCK.getId().toString());
            camoTag.m_128365_("state", (Tag)stateTag);
            tag.m_128365_(camoKey, (Tag)camoTag);
        }
    }

    @Nullable
    private static BlockEntity getExistingBlockEntity0(BlockGetter blockGetter, BlockPos pos) {
        if (blockGetter instanceof Level) {
            ChunkSource chunkSource;
            Level level = (Level)blockGetter;
            int chunkX = SectionPos.m_123171_((int)pos.m_123341_());
            int chunkZ = SectionPos.m_123171_((int)pos.m_123343_());
            try {
                chunkSource = level.m_7726_();
            }
            catch (Throwable t) {
                return null;
            }
            LightChunk chunk = chunkSource.m_6196_(chunkX, chunkZ);
            return chunk != null ? InternalApiImpl.getExistingBlockEntity0((BlockGetter)chunk, pos) : null;
        }
        if (blockGetter instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)blockGetter;
            return (BlockEntity)chunk.m_62954_().get(pos);
        }
        if (blockGetter instanceof ImposterProtoChunk) {
            ImposterProtoChunk chunk = (ImposterProtoChunk)blockGetter;
            return InternalApiImpl.getExistingBlockEntity0((BlockGetter)chunk.m_62768_(), pos);
        }
        return blockGetter.m_7702_(pos);
    }
}

