/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum EnumKeyType implements StringRepresentable
{
    DRAWER(0, "drawer"),
    CONCEALMENT(1, "concealment"),
    PERSONAL(2, "personal"),
    QUANTIFY(3, "quantify"),
    SUSPEND(4, "suspend");

    private static final EnumKeyType[] META_LOOKUP;
    private final int meta;
    private final String name;

    private EnumKeyType(int meta, String name) {
        this.meta = meta;
        this.name = name;
    }

    public int getMetadata() {
        return this.meta;
    }

    public static EnumKeyType byMetadata(int meta) {
        if (meta < 0 || meta >= META_LOOKUP.length) {
            meta = 0;
        }
        return META_LOOKUP[meta];
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }

    public String toString() {
        return this.m_7912_();
    }

    public boolean isEnabled() {
        boolean keyEnabled = false;
        if (this == DRAWER) {
            keyEnabled = (Boolean)ModCommonConfig.INSTANCE.TOOLS.drawerKey.enable.get();
        } else if (this == QUANTIFY) {
            keyEnabled = (Boolean)ModCommonConfig.INSTANCE.TOOLS.quantifyKey.enable.get();
        } else if (this == CONCEALMENT) {
            keyEnabled = (Boolean)ModCommonConfig.INSTANCE.TOOLS.concealmentKey.enable.get();
        } else if (this == PERSONAL) {
            keyEnabled = (Boolean)ModCommonConfig.INSTANCE.TOOLS.personalKey.enable.get();
        } else if (this == SUSPEND) {
            keyEnabled = (Boolean)ModCommonConfig.INSTANCE.TOOLS.suspendKey.enable.get();
        }
        return keyEnabled;
    }

    static {
        META_LOOKUP = new EnumKeyType[EnumKeyType.values().length];
        EnumKeyType[] enumKeyTypeArray = EnumKeyType.values();
        int n = enumKeyTypeArray.length;
        for (int i = 0; i < n; ++i) {
            EnumKeyType type;
            EnumKeyType.META_LOOKUP[type.getMetadata()] = type = enumKeyTypeArray[i];
        }
    }
}

