/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.IControlGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.StandardDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.texelsaurus.minecraft.chameleon.capabilities.ChameleonCapability;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class BlockEntityDrawersStandard
extends BlockEntityDrawers {
    public BlockEntityDrawersStandard(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public static BlockEntityDrawersStandard createEntity(int slotCount, BlockPos pos, BlockState state) {
        return switch (slotCount) {
            case 1 -> new Slot1(pos, state);
            case 2 -> new Slot2(pos, state);
            case 4 -> new Slot4(pos, state);
            default -> null;
        };
    }

    public static class Slot1
    extends BlockEntityDrawersStandard {
        private final GroupData groupData = new GroupData(1);

        public Slot1(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.STANDARD_DRAWERS_1.get(), pos, state);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    public static class Slot2
    extends BlockEntityDrawersStandard {
        private final GroupData groupData = new GroupData(2);

        public Slot2(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.STANDARD_DRAWERS_2.get(), pos, state);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    public static class Slot4
    extends BlockEntityDrawersStandard {
        private final GroupData groupData = new GroupData(4);

        public Slot4(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.STANDARD_DRAWERS_4.get(), pos, state);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    private class StandardDrawerData
    extends StandardDrawerGroup.DrawerData {
        private final int slot;

        public StandardDrawerData(StandardDrawerGroup group, int slot) {
            super(group);
            this.slot = slot;
        }

        @Override
        protected int getStackCapacity() {
            try {
                return Math.multiplyExact(BlockEntityDrawersStandard.this.upgrades().getStorageMultiplier(), BlockEntityDrawersStandard.this.getEffectiveDrawerCapacity());
            }
            catch (ArithmeticException e) {
                return Integer.MAX_VALUE;
            }
        }

        @Override
        protected void onItemChanged() {
            if (BlockEntityDrawersStandard.this.m_58904_() != null && !BlockEntityDrawersStandard.this.m_58904_().f_46443_) {
                BlockEntityDrawersStandard.this.m_6596_();
                BlockEntityDrawersStandard.this.markBlockForUpdate();
            }
        }

        @Override
        protected void onAmountChanged() {
            if (BlockEntityDrawersStandard.this.m_58904_() != null && !BlockEntityDrawersStandard.this.m_58904_().f_46443_) {
                BlockEntityDrawersStandard.this.syncClientCount(this.slot, this.getStoredItemCount());
                BlockEntityDrawersStandard.this.m_6596_();
            }
        }
    }

    private class GroupData
    extends StandardDrawerGroup
    implements IProtectable,
    INetworked {
        public GroupData(int slotCount) {
            super(slotCount);
        }

        @Override
        @NotNull
        protected StandardDrawerGroup.DrawerData createDrawer(int slot) {
            return new StandardDrawerData(this, slot);
        }

        @Override
        public boolean isGroupValid() {
            return BlockEntityDrawersStandard.this.isGroupValid();
        }

        @Override
        public <T> T getCapability(ChameleonCapability<T> capability) {
            if (BlockEntityDrawersStandard.this.f_58857_ == null) {
                return null;
            }
            return capability.getCapability(BlockEntityDrawersStandard.this.f_58857_, BlockEntityDrawersStandard.this.m_58899_());
        }

        @Override
        public UUID getOwner() {
            return BlockEntityDrawersStandard.this.getOwner();
        }

        @Override
        public boolean setOwner(UUID owner) {
            return BlockEntityDrawersStandard.this.setOwner(owner);
        }

        @Override
        public ISecurityProvider getSecurityProvider() {
            return BlockEntityDrawersStandard.this.getSecurityProvider();
        }

        @Override
        public boolean setSecurityProvider(ISecurityProvider provder) {
            return BlockEntityDrawersStandard.this.setSecurityProvider(provder);
        }

        @Override
        public IControlGroup getBoundControlGroup() {
            return BlockEntityDrawersStandard.this.getBoundControlGroup();
        }

        @Override
        public Set<IControlGroup> getSoftBoundControlGroups() {
            return BlockEntityDrawersStandard.this.getSoftBoundControlGroups();
        }
    }
}

