/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.gui;

import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageGuiGraphics
extends GuiGraphics {
    private final Minecraft minecraft;
    private GuiGraphics baseGraphics;
    @NotNull
    public ItemStack overrideStack;

    public StorageGuiGraphics(Minecraft p_283406_, MultiBufferSource.BufferSource p_282238_) {
        super(p_283406_, p_282238_);
        this.minecraft = p_283406_;
        this.overrideStack = ItemStack.f_41583_;
    }

    public StorageGuiGraphics(Minecraft minecraft, GuiGraphics graphics) {
        super(minecraft, graphics.m_280168_(), graphics.m_280091_());
        this.baseGraphics = graphics;
        this.minecraft = minecraft;
        this.overrideStack = ItemStack.f_41583_;
    }

    public GuiGraphics baseGraphics() {
        return this.baseGraphics;
    }

    public void m_280302_(Font font, ItemStack item, int x, int y, @Nullable String text) {
        if (item != this.overrideStack) {
            super.m_280302_(font, item, x, y, text);
            return;
        }
        if (!item.m_41619_()) {
            LocalPlayer localplayer;
            float f;
            item = ItemStackHelper.decodeItemStack(item);
            float scale = 0.5f;
            float xoff = 0.0f;
            int stackSize = item.m_41613_();
            if (ItemStackHelper.isStackEncoded(item)) {
                stackSize = 0;
            }
            this.m_280168_().m_85836_();
            if (stackSize >= 0 || text != null) {
                text = stackSize >= 100000000 ? (text == null ? String.format("%.0fM", Float.valueOf((float)stackSize / 1000000.0f)) : text) : (stackSize >= 1000000 ? (text == null ? String.format("%.1fM", Float.valueOf((float)stackSize / 1000000.0f)) : text) : (stackSize >= 100000 ? (text == null ? String.format("%.0fK", Float.valueOf((float)stackSize / 1000.0f)) : text) : (stackSize >= 10000 ? (text == null ? String.format("%.1fK", Float.valueOf((float)stackSize / 1000.0f)) : text) : (text == null ? String.valueOf(stackSize) : text))));
                int textX = (int)(((float)(x + 16) + xoff - (float)font.m_92895_(text) * scale) / scale) - 1;
                int textY = (int)(((float)(y + 16) - 7.0f * scale) / scale) - 1;
                int color = 0xFFFFFF;
                if (stackSize == 0) {
                    color = 0xFF6060;
                }
                this.m_280168_().m_85841_(scale, scale, 1.0f);
                this.m_280168_().m_85837_(0.0, 0.0, 200.0);
                this.m_280056_(font, text, textX, textY, color, true);
            }
            if (item.m_41720_().m_142522_(item)) {
                int barWidth = item.m_41720_().m_142158_(item);
                int color = item.m_41720_().m_142159_(item);
                int x1 = x + 2;
                int y1 = y + 13;
                this.m_285944_(RenderType.m_286086_(), x1, y1, x1 + 13, y1 + 2, -16777216);
                this.m_285944_(RenderType.m_286086_(), x1, y1, x1 + barWidth, y1 + 1, color | 0xFF000000);
            }
            float f2 = f = (localplayer = this.minecraft.f_91074_) == null ? 0.0f : localplayer.m_36335_().m_41521_(item.m_41720_(), this.minecraft.m_91296_());
            if (f > 0.0f) {
                int y1 = y + Mth.m_14143_((float)(16.0f * (1.0f - f)));
                int y2 = y1 + Mth.m_14167_((float)(16.0f * f));
                this.m_285944_(RenderType.m_286086_(), x, y1, x + 16, y2, Integer.MAX_VALUE);
            }
            this.m_280168_().m_85849_();
        }
    }
}

