/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.integration.IntegrationRegistry;
import com.jaquadro.minecraft.storagedrawers.integration.cofh.CoFHModule;
import com.jaquadro.minecraft.storagedrawers.integration.ftb.FTBChunksModule;
import com.jaquadro.minecraft.storagedrawers.integration.ftb.FTBTeamsModule;
import net.minecraftforge.fml.ModList;

public class LocalIntegrationRegistry {
    private static LocalIntegrationRegistry instance;
    private final IntegrationRegistry registry = new IntegrationRegistry("storagedrawers");

    public static void initialize() {
        IntegrationRegistry reg = LocalIntegrationRegistry.instance();
        if (ModList.get().isLoaded("cofh_core") && ((Boolean)ModCommonConfig.INSTANCE.INTEGRATION.cofhCore.enable.get()).booleanValue()) {
            reg.add(new CoFHModule());
        }
        if (ModList.get().isLoaded("ftbteams") && ((Boolean)ModCommonConfig.INSTANCE.INTEGRATION.ftbTeams.enable.get()).booleanValue()) {
            reg.add(new FTBTeamsModule());
        }
        if (ModList.get().isLoaded("ftbchunks") && ((Boolean)ModCommonConfig.INSTANCE.INTEGRATION.ftbChunks.enable.get()).booleanValue()) {
            reg.add(new FTBChunksModule());
        }
    }

    private LocalIntegrationRegistry() {
    }

    public static boolean isModLoaded(String modid) {
        if (instance == null) {
            instance = new LocalIntegrationRegistry();
        }
        return LocalIntegrationRegistry.instance.registry.isModLoaded(modid);
    }

    public static IntegrationRegistry instance() {
        if (instance == null) {
            instance = new LocalIntegrationRegistry();
        }
        return LocalIntegrationRegistry.instance.registry;
    }
}

