/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.camera.infrastructure.FrameData;
import io.github.mortuusars.exposure.gui.ClientGUI;
import io.github.mortuusars.exposure.gui.component.PhotographTooltip;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhotographItem
extends Item {
    public PhotographItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack stack) {
        return FrameData.hasIdOrTexture(stack) ? Optional.of(new PhotographTooltip(stack)) : Optional.empty();
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        String photographerName;
        if (stack.m_41783_() == null) {
            return;
        }
        int generation = stack.m_41783_().m_128451_("generation");
        if (generation > 0) {
            tooltipComponents.add((Component)Component.m_237115_((String)("item.exposure.photograph.generation." + generation)).m_130940_(ChatFormatting.GRAY));
        }
        if (!(photographerName = stack.m_41783_().m_128461_("Photographer")).isEmpty() && ((Boolean)Config.Client.PHOTOGRAPH_SHOW_PHOTOGRAPHER_IN_TOOLTIP.get()).booleanValue()) {
            tooltipComponents.add((Component)Component.m_237110_((String)"item.exposure.photograph.photographer_tooltip", (Object[])new Object[]{Component.m_237113_((String)photographerName).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GRAY));
        }
        if (generation < 2 && !PlatformHelper.isModLoaded("jei") && ((Boolean)Config.Client.RECIPE_TOOLTIPS_WITHOUT_JEI.get()).booleanValue()) {
            ClientGUI.addPhotographCopyingTooltip(stack, level, tooltipComponents, isAdvanced);
        }
        if (isAdvanced.m_7050_()) {
            String str = (String)FrameData.getIdOrTexture(stack.m_41783_()).map(id -> "Exposure Id: " + id, texture -> "Texture: " + String.valueOf(texture));
            tooltipComponents.add((Component)Component.m_237113_((String)str).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (!FrameData.hasIdOrTexture(itemInHand)) {
            Exposure.LOGGER.warn("No Id or Texture is defined. - {}", (Object)itemInHand);
            return InteractionResultHolder.m_19098_((Object)itemInHand);
        }
        if (level.f_46443_) {
            ClientGUI.openPhotographScreen(List.of(new ItemAndStack(itemInHand)));
            player.m_5496_(Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), 0.6f, 1.1f);
        }
        return InteractionResultHolder.m_19090_((Object)itemInHand);
    }

    public boolean m_142305_(@NotNull ItemStack stack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        if (other.m_41720_() instanceof PhotographItem) {
            StackedPhotographsItem stackedPhotographsItem = Exposure.Items.STACKED_PHOTOGRAPHS.get();
            ItemStack stackedPhotographsStack = new ItemStack((ItemLike)stackedPhotographsItem);
            stackedPhotographsItem.addPhotographOnTop(stackedPhotographsStack, stack);
            stackedPhotographsItem.addPhotographOnTop(stackedPhotographsStack, other);
            slot.m_5852_(stackedPhotographsStack);
            access.m_142104_(ItemStack.f_41583_);
            StackedPhotographsItem.playAddSoundClientside(player);
            return true;
        }
        return false;
    }
}

