/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.util.supporter;

import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.util.supporter.Gilded;
import io.github.mortuusars.exposure.util.supporter.Patreon;
import io.github.mortuusars.exposure.util.supporter.Supporter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Supporters {
    private static final Gilded gilded = new Gilded();
    private static final Patreon patreon = new Patreon();

    public static void query() {
        gilded.query();
        patreon.query();
    }

    public static Gilded gilded() {
        return gilded;
    }

    public static Patreon patreon() {
        return patreon;
    }

    public static boolean hasAccessToGoldenSkin(UUID uuid) {
        return Supporters.gilded().hasAccessToGoldenSkin(uuid) || Supporters.patreon().hasAccessToGoldenSkin(uuid);
    }

    public static class Loader {
        @Nullable
        public String readFileFromURL(URI uri) {
            String string;
            URL url = uri.toURL();
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(10000);
            @Nullable String encoding = connection.getContentEncoding();
            Charset charset = encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), charset));
            try {
                string = CharStreams.toString((Readable)reader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Exposure.LOGGER.warn("Cannot read file from '{}': {}", (Object)uri, (Object)e.getMessage());
                    return null;
                }
            }
            ((Reader)reader).close();
            return string;
        }

        @NotNull
        public List<Supporter> parseSupporters(String json) {
            try {
                Gson gson = new Gson();
                JsonArray array = JsonParser.parseString((String)json).getAsJsonArray();
                ArrayList<Supporter> supporters = new ArrayList<Supporter>();
                for (JsonElement element : array) {
                    try {
                        Supporter p = (Supporter)gson.fromJson(element, Supporter.class);
                        supporters.add(p);
                    }
                    catch (Exception e) {
                        Exposure.LOGGER.warn("Cannot parse supporter from '{}': {}", (Object)element, (Object)e.getMessage());
                    }
                }
                return supporters;
            }
            catch (Exception e) {
                Exposure.LOGGER.warn("Cannot get list of supporters: {}", (Object)e.getMessage());
                return Collections.emptyList();
            }
        }
    }
}

