/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.fullDatafile;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalNotification;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.KeyedLockContainer;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DelayedFullDataSourceSaveCache
implements AutoCloseable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final ThreadPoolExecutor BACKGROUND_CLEAN_UP_THREAD = ThreadUtil.makeSingleDaemonThreadPool("delayed save cache cleaner");
    private static final Set<WeakReference<DelayedFullDataSourceSaveCache>> SAVE_CACHE_SET = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final int CLEANUP_CHECK_TIME_IN_MS = 1000;
    private final Cache<Long, FullDataSourceV2> dataSourceByPosition;
    protected final KeyedLockContainer<Long> saveLockContainer = new KeyedLockContainer();
    private final ISaveDataSourceFunc onSaveTimeoutAsyncFunc;
    private final int saveDelayInMs;

    public DelayedFullDataSourceSaveCache(@NotNull ISaveDataSourceFunc onSaveTimeoutAsyncFunc, int saveDelayInMs) {
        this.onSaveTimeoutAsyncFunc = onSaveTimeoutAsyncFunc;
        this.saveDelayInMs = saveDelayInMs;
        this.dataSourceByPosition = CacheBuilder.newBuilder().expireAfterAccess((long)this.saveDelayInMs, TimeUnit.MILLISECONDS).expireAfterWrite((long)this.saveDelayInMs, TimeUnit.MILLISECONDS).removalListener(this::handleDataSourceRemoval).build();
        SAVE_CACHE_SET.add(new WeakReference<DelayedFullDataSourceSaveCache>(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDataSourceToMemoryAndQueueSave(FullDataSourceV2 inputDataSource) {
        long inputPos = inputDataSource.getPos();
        ReentrantLock lock = this.saveLockContainer.getLockForPos(inputPos);
        try {
            lock.lock();
            FullDataSourceV2 memoryDataSource = (FullDataSourceV2)this.dataSourceByPosition.getIfPresent((Object)inputPos);
            if (memoryDataSource == null) {
                memoryDataSource = FullDataSourceV2.createEmpty(inputPos);
            }
            memoryDataSource.update(inputDataSource);
            this.dataSourceByPosition.put((Object)inputPos, (Object)memoryDataSource);
        }
        finally {
            lock.unlock();
        }
    }

    public void handleDataSourceRemoval(RemovalNotification<Long, FullDataSourceV2> removalNotification) {
        RemovalCause cause = removalNotification.getCause();
        if (cause == RemovalCause.EXPIRED || cause == RemovalCause.COLLECTED || cause == RemovalCause.EXPLICIT || cause == RemovalCause.SIZE) {
            FullDataSourceV2 dataSource = (FullDataSourceV2)removalNotification.getValue();
            if (dataSource != null) {
                this.onSaveTimeoutAsyncFunc.saveAsync(dataSource).handle((voidObj, throwable) -> {
                    try {
                        dataSource.close();
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to close datasource [" + DhSectionPos.toString(dataSource.getPos()) + "], removal cause: [" + cause + "], error: [" + e.getMessage() + "].", (Throwable)e);
                    }
                    return null;
                });
            } else {
                LOGGER.error("Unable to close null cached data source.");
            }
        }
    }

    public int getUnsavedCount() {
        return (int)this.dataSourceByPosition.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Set keySet = this.dataSourceByPosition.asMap().keySet();
        for (Long pos : keySet) {
            ReentrantLock lock = this.saveLockContainer.getLockForPos(pos);
            try {
                lock.lock();
                this.dataSourceByPosition.invalidate((Object)pos);
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static void runCleanupLoop() {
        while (true) {
            try {
                while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    SAVE_CACHE_SET.forEach(cacheRef -> {
                        DelayedFullDataSourceSaveCache cache = (DelayedFullDataSourceSaveCache)cacheRef.get();
                        if (cache == null) {
                            SAVE_CACHE_SET.remove(cacheRef);
                        } else {
                            cache.dataSourceByPosition.cleanUp();
                        }
                    });
                }
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error in cleanup thread: [" + e.getMessage() + "].", (Throwable)e);
                continue;
            }
            break;
        }
    }

    @Override
    public void close() {
        SAVE_CACHE_SET.removeIf(cacheRef -> {
            DelayedFullDataSourceSaveCache cache = (DelayedFullDataSourceSaveCache)cacheRef.get();
            return cache != null && cache.equals(this);
        });
    }

    static {
        BACKGROUND_CLEAN_UP_THREAD.execute(() -> DelayedFullDataSourceSaveCache.runCleanupLoop());
    }

    @FunctionalInterface
    public static interface ISaveDataSourceFunc {
        public CompletableFuture<Void> saveAsync(FullDataSourceV2 var1);
    }
}

