/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.networking;

import com.github.nyuppo.networking.S2CRespondVariantPacketHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class S2CRespondVariantPacket {
    private final int id;
    private final String variant;
    private byte responseType;
    private boolean isMuddy;
    private int muddyTimeout;
    private String hornColour;
    private boolean sitting;

    public S2CRespondVariantPacket(int id, String variant) {
        this.id = id;
        this.variant = variant;
        this.responseType = 0;
        this.isMuddy = false;
        this.muddyTimeout = 0;
        this.hornColour = "";
        this.sitting = false;
    }

    public S2CRespondVariantPacket(int id, String variant, boolean isMuddy, int muddyTimeout) {
        this.id = id;
        this.variant = variant;
        this.responseType = 1;
        this.isMuddy = isMuddy;
        this.muddyTimeout = muddyTimeout;
        this.hornColour = "";
        this.sitting = false;
    }

    public S2CRespondVariantPacket(int id, String variant, String hornColour) {
        this.id = id;
        this.variant = variant;
        this.responseType = (byte)2;
        this.isMuddy = false;
        this.muddyTimeout = 0;
        this.hornColour = hornColour;
        this.sitting = false;
    }

    public S2CRespondVariantPacket(int id, String variant, boolean sitting) {
        this.id = id;
        this.variant = variant;
        this.responseType = (byte)3;
        this.isMuddy = false;
        this.muddyTimeout = 0;
        this.hornColour = "";
        this.sitting = sitting;
    }

    public S2CRespondVariantPacket(FriendlyByteBuf buffer) {
        this.id = buffer.readInt();
        this.variant = buffer.m_130277_();
        this.responseType = buffer.readByte();
        this.isMuddy = false;
        this.muddyTimeout = 0;
        this.hornColour = "";
        if (this.responseType == 1) {
            this.isMuddy = buffer.readBoolean();
            this.muddyTimeout = buffer.readInt();
        } else if (this.responseType == 2) {
            this.hornColour = buffer.m_130277_();
        } else if (this.responseType == 3) {
            this.sitting = buffer.readBoolean();
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        buffer.m_130070_(this.variant);
        buffer.writeByte((int)this.responseType);
        if (this.responseType == 1) {
            buffer.writeBoolean(this.isMuddy);
            buffer.writeInt(this.muddyTimeout);
        } else if (this.responseType == 2) {
            buffer.m_130070_(this.hornColour);
        } else if (this.responseType == 3) {
            buffer.writeBoolean(this.sitting);
        }
    }

    public static void handle(S2CRespondVariantPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> S2CRespondVariantPacket.lambda$handle$1(msg, (Supplier)ctx)));
        ctx.get().setPacketHandled(true);
    }

    public int getId() {
        return this.id;
    }

    public String getVariant() {
        return this.variant;
    }

    public byte getResponseType() {
        return this.responseType;
    }

    public boolean isMuddy() {
        return this.isMuddy;
    }

    public int getMuddyTimeout() {
        return this.muddyTimeout;
    }

    public void setPigData(boolean isMuddy, int muddyTimeout) {
        this.responseType = 1;
        this.isMuddy = isMuddy;
        this.muddyTimeout = muddyTimeout;
    }

    public String getHornColour() {
        return this.hornColour;
    }

    public void setSheepData(String hornColour) {
        this.responseType = (byte)2;
        this.hornColour = hornColour;
    }

    public boolean isSitting() {
        return this.sitting;
    }

    public void setSitting(boolean sitting) {
        this.responseType = (byte)3;
        this.sitting = sitting;
    }

    private static /* synthetic */ Runnable lambda$handle$1(S2CRespondVariantPacket msg, Supplier ctx) {
        return () -> S2CRespondVariantPacket.lambda$handle$0(msg, (Supplier)ctx);
    }

    private static /* synthetic */ void lambda$handle$0(S2CRespondVariantPacket msg, Supplier ctx) {
        S2CRespondVariantPacketHandler.handlePacket(msg, ctx);
    }
}

